/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;

public class ItemUtil {
    public static boolean isEqual(class_1792 item, class_1792 item2) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isEqual(item, item2);
    }

    public static class_1792 fromId(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.fromId(id);
    }

    public static class_1792 fromId(String id) {
        return ItemUtil.fromId(CompatIdentifier.of(id));
    }

    public static class_1792 fromId(String namespace, String path) {
        return ItemUtil.fromId(CompatIdentifier.of(namespace, path));
    }

    public static CompatIdentifier toId(class_1792 item) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.toCompatID(item);
    }

    public static String toIdAsString(class_1792 item) {
        return ItemUtil.toId(item).toString();
    }

    public static boolean isExist(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isExist(id);
    }

    public static boolean isExist(String id) {
        return ItemUtil.isExist(CompatIdentifier.of(id));
    }

    public static boolean isExist(String namespace, String path) {
        return ItemUtil.isExist(CompatIdentifier.of(namespace, path));
    }

    public static boolean isMinecraftItem(class_1792 item) {
        return CompatIdentifier.isMinecraftNamespace(ItemUtil.toId(item));
    }

    public static class_1747 create(class_2248 block, CompatibleItemSettings settings) {
        if (!settings.changedTranslationKey) {
            settings.useBlockPrefixedTranslationKey();
        }
        return net.pitan76.mcpitanlib.api.util.ItemUtil.ofBlock(block, settings);
    }

    public static class_1792 create(CompatibleItemSettings settings) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.of(settings);
    }

    public static List<class_1792> getItems() {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getAllItems();
    }

    public static List<class_1792> getInTag(TagKey<class_1792> tagKey) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getItems(tagKey);
    }

    public static List<class_1792> getInTag(CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getItems(id);
    }

    public static List<class_1792> getInTag(String id) {
        return ItemUtil.getInTag(CompatIdentifier.of(id));
    }

    public static List<class_1792> getInTag(String namespace, String path) {
        return ItemUtil.getInTag(CompatIdentifier.of(namespace, path));
    }

    public static boolean isInTag(class_1792 item, TagKey<class_1792> tagKey) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isIn(item, tagKey);
    }

    public static boolean isInTag(class_1792 item, CompatIdentifier id) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isItemInTag(item, id);
    }

    public static boolean isInTag(class_1792 item, String id) {
        return ItemUtil.isInTag(item, CompatIdentifier.of(id));
    }

    public static boolean isInTag(class_1792 item, String namespace, String path) {
        return ItemUtil.isInTag(item, CompatIdentifier.of(namespace, path));
    }

    public static int toRawId(class_1792 item) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.getRawId(item);
    }

    public static class_1792 fromRawId(int rawId) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.fromIndex(rawId);
    }

    public static List<class_1792> getItemsByNamespace(String namespace) {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        for (class_1792 item : ItemUtil.getItems()) {
            if (!ItemUtil.toId(item).getNamespace().equals(namespace)) continue;
            items.add(item);
        }
        return items;
    }

    public static int getNumberOfItems() {
        return ItemUtil.getItems().size();
    }

    public static class_1792 of(class_1799 stack) {
        return stack.method_7909();
    }

    public static boolean isOf(class_1799 stack, class_1792 item) {
        return net.pitan76.mcpitanlib.api.util.ItemUtil.isOf(stack, item);
    }

    public static String getNameAsString(class_1792 item) {
        return item.method_63680().getString();
    }

    public static TextComponent getName(class_1792 item) {
        return new TextComponent(item.method_63680());
    }

    public static String getTranslationKey(class_1792 item) {
        return item.method_7876();
    }

    public static boolean hasRecipeRemainder(class_1792 item) {
        return !ItemStackUtil.isEmpty(ItemUtil.getRecipeRemainderStack(item));
    }

    public static class_1792 getRecipeRemainder(class_1792 item) {
        return ItemUtil.getRecipeRemainderStack(item).method_7909();
    }

    public static class_1799 getRecipeRemainderStack(class_1792 item) {
        return item.method_7858();
    }
}

