/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.util.math;

import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.pitan76.mcpitanlib.midohra.util.math.Vector3f;
import net.pitan76.mcpitanlib.midohra.util.math.Vector3i;

public class Vector3d {
    public final double x;
    public final double y;
    public final double z;

    public Vector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Vector3d of(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }

    public static Vector3d of(Vector3i vec) {
        return new Vector3d(vec.x, vec.y, vec.z);
    }

    public static Vector3d of(Vector3f vec) {
        return new Vector3d(vec.x, vec.y, vec.z);
    }

    public static Vector3d of(org.joml.Vector3d vec) {
        return new Vector3d(vec.x, vec.y, vec.z);
    }

    public static Vector3d of(class_243 vec) {
        return new Vector3d(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public static Vector3d of(class_2374 vec) {
        return new Vector3d(vec.method_10216(), vec.method_10214(), vec.method_10215());
    }

    public Vector3i toInt() {
        return new Vector3i((int)this.x, (int)this.y, (int)this.z);
    }

    public Vector3f toFloat() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public org.joml.Vector3d toJoml() {
        return new org.joml.Vector3d(this.x, this.y, this.z);
    }

    public Vector3d add(Vector3d other) {
        return new Vector3d(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3d sub(Vector3d other) {
        return new Vector3d(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3d mul(double scalar) {
        return new Vector3d(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector3d div(double scalar) {
        return new Vector3d(this.x / scalar, this.y / scalar, this.z / scalar);
    }

    public double dot(Vector3d other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3d cross(Vector3d other) {
        return new Vector3d(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3d normalize() {
        double len = this.length();
        if (len == 0.0) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        return this.div(len);
    }

    public Vector3d add(double x, double y, double z) {
        return new Vector3d(this.x + x, this.y + y, this.z + z);
    }

    public Vector3d sub(double x, double y, double z) {
        return new Vector3d(this.x - x, this.y - y, this.z - z);
    }

    public Vector3d lerp(Vector3d to, double delta) {
        return this.mul(1.0 - delta).add(to.mul(delta));
    }

    public Vector3d rotateX(double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double cos = Math.cos(angleRadians);
        double sin = Math.sin(angleRadians);
        double newY = this.y * cos - this.z * sin;
        double newZ = this.y * sin + this.z * cos;
        return new Vector3d(this.x, newY, newZ);
    }

    public Vector3d rotateY(double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double cos = Math.cos(angleRadians);
        double sin = Math.sin(angleRadians);
        double newX = this.x * cos - this.z * sin;
        double newZ = this.x * sin + this.z * cos;
        return new Vector3d(newX, this.y, newZ);
    }

    public Vector3d rotateZ(double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double cos = Math.cos(angleRadians);
        double sin = Math.sin(angleRadians);
        double newX = this.x * cos - this.y * sin;
        double newY = this.x * sin + this.y * cos;
        return new Vector3d(newX, newY, this.z);
    }

    public Vector3d negate() {
        return new Vector3d(-this.x, -this.y, -this.z);
    }

    public Vector3d abs() {
        return new Vector3d(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public Vector3d distanceTo(Vector3d other) {
        return this.sub(other);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public static Vector3d zero() {
        return new Vector3d(0.0, 0.0, 0.0);
    }

    public static Vector3d distance(Vector3d a, Vector3d b) {
        return a.sub(b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3d vec = (Vector3d)obj;
        return this.x == vec.x && this.y == vec.y && this.z == vec.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public int hashCode() {
        int h = Double.hashCode(this.x);
        h = 31 * h + Double.hashCode(this.y);
        h = 31 * h + Double.hashCode(this.z);
        return h;
    }
}

