/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class CustomDataUtil {
    public static CompoundTag getOrCreateNbt(ItemStack stack) {
        if (!CustomDataUtil.hasNbt(stack)) {
            return NbtUtil.create();
        }
        return CustomDataUtil.getNbt(stack);
    }

    public static void setNbt(ItemStack stack, CompoundTag nbt) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    public static boolean hasNbt(ItemStack stack) {
        return stack.contains(DataComponents.CUSTOM_DATA);
    }

    public static CompoundTag getNbt(ItemStack stack) {
        if (stack.get(DataComponents.CUSTOM_DATA) == null) {
            return NbtUtil.create();
        }
        return ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
    }

    public static void put(ItemStack stack, String key, CompoundTag value) {
        CompoundTag nbt = CustomDataUtil.getOrCreateNbt(stack);
        NbtUtil.put(nbt, key, value);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static CompoundTag get(ItemStack stack, String key) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return nbt.getCompoundOrEmpty(key);
    }

    public static void remove(ItemStack stack, String key) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        nbt.remove(key);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static boolean has(ItemStack stack, String key) {
        if (!CustomDataUtil.hasNbt(stack)) {
            return false;
        }
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return nbt.contains(key);
    }

    public static <T> T get(ItemStack stack, String key, Class<T> clazz) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return NbtUtil.get(nbt, key, clazz);
    }

    public static <T> void set(ItemStack stack, String key, T value) {
        CompoundTag nbt = CustomDataUtil.getOrCreateNbt(stack);
        NbtUtil.set(nbt, key, value);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static Set<String> getKeys(ItemStack stack) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return NbtUtil.getKeys(nbt);
    }

    public static <T> void put(ItemStack stack, String key, T value) {
        CustomDataUtil.set(stack, key, value);
    }

    public static boolean contains(ItemStack stack, String key) {
        return CustomDataUtil.has(stack, key);
    }

    public static void fix_oldNbt(ItemStack stack, String[] keys) {
    }

    public static void remove(ItemStack stack) {
        stack.remove(DataComponents.CUSTOM_DATA);
    }
}

