/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.world.CompatiblePersistentState;

public class PersistentStateUtil {
    public static <T extends SavedData> T getOrCreate(DimensionDataStorage manager, String id, Supplier<T> supplier, Function<CompoundTag, T> function) {
        Codec codec = CompoundTag.CODEC.xmap(nbt -> {
            SavedData state = (SavedData)supplier.get();
            if (state instanceof CompatiblePersistentState) {
                ((CompatiblePersistentState)state).readNbt(new ReadNbtArgs((CompoundTag)nbt));
            }
            return state;
        }, state -> {
            if (state instanceof CompatiblePersistentState) {
                return ((CompatiblePersistentState)((Object)state)).writeNbt(new WriteNbtArgs(new CompoundTag()));
            }
            return NbtUtil.create();
        });
        SavedDataType type = new SavedDataType(id, supplier, codec, DataFixTypes.LEVEL);
        return (T)manager.computeIfAbsent(type);
    }

    public static DimensionDataStorage getManagerFromServer(MinecraftServer server) {
        return server.getLevel(Level.OVERWORLD).getDataStorage();
    }

    public static DimensionDataStorage getManagerFromWorld(ServerLevel world) {
        return world.getDataStorage();
    }

    public static void markDirty(SavedData state) {
        state.setDirty();
    }
}

