/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.v2;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;

public class CustomNameUtil {
    public static void setCustomName(ItemStack stack, Component name) {
        stack.set(DataComponents.CUSTOM_NAME, (Object)name);
    }

    public static void setCustomName(ItemStack stack, String name) {
        CustomNameUtil.setCustomNameFromString(stack, name);
    }

    public static void setCustomNameFromString(ItemStack stack, String name) {
        CustomNameUtil.setCustomName(stack, (Component)TextUtil.literal(name));
    }

    public static void setCustomNameFromTranslatable(ItemStack stack, String key) {
        CustomNameUtil.setCustomName(stack, (Component)TextUtil.translatable(key));
    }

    public static void setCustomName(ItemStack stack, TextComponent name) {
        CustomNameUtil.setCustomName(stack, name.getText());
    }

    public static Component getCustomName(ItemStack stack) {
        return (Component)stack.get(DataComponents.CUSTOM_NAME);
    }

    public static String getCustomNameAsString(ItemStack stack) {
        return CustomNameUtil.getCustomName(stack).getString();
    }

    public static TextComponent getCustomNameAsTextComponent(ItemStack stack) {
        return new TextComponent(CustomNameUtil.getCustomName(stack));
    }

    public static boolean hasCustomName(ItemStack stack) {
        return stack.contains(DataComponents.CUSTOM_NAME);
    }

    public static void removeCustomName(ItemStack stack) {
        stack.remove(DataComponents.CUSTOM_NAME);
    }
}

