/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.recipe.entry;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeEntry;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.midohra.recipe.CraftingRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.Recipe;
import net.pitan76.mcpitanlib.midohra.recipe.RecipeType;
import net.pitan76.mcpitanlib.midohra.recipe.ShapedRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.ShapelessRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.entry.CraftingRecipeEntry;
import net.pitan76.mcpitanlib.midohra.recipe.entry.ShapedRecipeEntry;
import net.pitan76.mcpitanlib.midohra.recipe.entry.ShapelessRecipeEntry;

public class RecipeEntry {
    private final RecipeHolder<?> recipeEntry;

    protected RecipeEntry(RecipeHolder<?> recipeEntry) {
        this.recipeEntry = recipeEntry;
    }

    public static RecipeEntry of(RecipeHolder<?> recipeEntry) {
        return new RecipeEntry(recipeEntry);
    }

    public static RecipeEntry of(net.minecraft.world.item.crafting.Recipe<?> recipe, CompatIdentifier id) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)id.toMinecraft());
        RecipeHolder recipeEntry = new RecipeHolder(key, recipe);
        return RecipeEntry.of(recipeEntry);
    }

    public static RecipeEntry of(Recipe recipe, CompatIdentifier id) {
        return RecipeEntry.of(recipe.toMinecraft(), id);
    }

    public static CraftingRecipeEntry of(net.minecraft.world.item.crafting.CraftingRecipe recipe, CompatIdentifier id) {
        return CraftingRecipeEntry.of(recipe, id);
    }

    public static CraftingRecipeEntry of(CraftingRecipe recipe, CompatIdentifier id) {
        return CraftingRecipeEntry.of(recipe, id);
    }

    public static ShapedRecipeEntry of(net.minecraft.world.item.crafting.ShapedRecipe recipe, CompatIdentifier id) {
        return ShapedRecipeEntry.of(recipe, id);
    }

    public static ShapedRecipeEntry of(ShapedRecipe recipe, CompatIdentifier id) {
        return ShapedRecipeEntry.of(recipe, id);
    }

    public static ShapelessRecipeEntry of(net.minecraft.world.item.crafting.ShapelessRecipe recipe, CompatIdentifier id) {
        return ShapelessRecipeEntry.of(recipe, id);
    }

    public static ShapelessRecipeEntry of(ShapelessRecipe recipe, CompatIdentifier id) {
        return ShapelessRecipeEntry.of(recipe, id);
    }

    public RecipeHolder<?> getRaw() {
        return this.recipeEntry;
    }

    public RecipeHolder<?> toMinecraft() {
        return this.getRaw();
    }

    public CompatIdentifier getId() {
        return CompatIdentifier.fromMinecraft(this.getRaw().id().location());
    }

    public CompatRecipeEntry<?> toCompatRecipeEntry() {
        return new CompatRecipeEntry(this.getRaw());
    }

    public net.minecraft.world.item.crafting.Recipe<?> getRawRecipe() {
        return this.getRaw().value();
    }

    public Recipe getRecipe() {
        return Recipe.of(this.getRaw().value());
    }

    public RecipeType getRecipeType() {
        return RecipeType.of(this.getRawRecipeType());
    }

    public net.minecraft.world.item.crafting.RecipeType getRawRecipeType() {
        return this.getRaw().value().getType();
    }
}

