/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.holder.BlockStatePropertyHolder;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;

public class TileTickEvent<T extends BlockEntity>
implements BlockStatePropertyHolder {
    public Level world;
    public BlockPos pos;
    public BlockState state;
    public T blockEntity;

    public TileTickEvent(Level world, BlockPos pos, BlockState state, T blockEntity) {
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.blockEntity = blockEntity;
    }

    public boolean isClient() {
        return this.world.isClientSide();
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        if (this.state == null) {
            this.state = this.getWorldView().getBlockState(this.getPos());
        }
        return this.state;
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public World getMidohraWorld() {
        return World.of(this.getWorld());
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getPos());
    }

    public net.pitan76.mcpitanlib.midohra.block.BlockState getMidohraState() {
        if (this.state == null) {
            return this.getWorldView().getBlockState(this.getMidohraPos());
        }
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(this.getState());
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    @Override
    public net.pitan76.mcpitanlib.midohra.block.BlockState getBlockState() {
        return this.getMidohraState();
    }

    public Block getBlock() {
        return this.getState().getBlock();
    }

    public BlockWrapper getBlockWrapper() {
        return BlockWrapper.of(this.getBlock());
    }
}

