/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.v0.event;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.gson.JsonElement;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.pitan76.mcpitanlib.api.recipe.CompatibleRecipeEntry;
import net.pitan76.mcpitanlib.api.recipe.v2.CompatRecipeEntry;
import net.pitan76.mcpitanlib.api.recipe.v3.CompatRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.entry.RecipeEntry;

public class RecipeManagerEvent {
    public Map<ResourceLocation, JsonElement> jsonMap;
    public ResourceManager resourceManager;
    public ProfilerFiller profiler;
    @Deprecated
    public ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> recipesById;
    @Deprecated
    public ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> recipesByType;

    public RecipeManagerEvent(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler, ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> recipesById, ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> recipesByType) {
        this.jsonMap = map;
        this.resourceManager = resourceManager;
        this.profiler = profiler;
        this.recipesById = recipesById;
        this.recipesByType = recipesByType;
    }

    public Map<ResourceLocation, JsonElement> getJsonMap() {
        return this.jsonMap;
    }

    @Deprecated
    public ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> getRecipesById() {
        return this.recipesById;
    }

    @Deprecated
    public ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> getRecipesByType() {
        return this.recipesByType;
    }

    public ProfilerFiller getProfiler() {
        return this.profiler;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public net.pitan76.mcpitanlib.midohra.resource.ResourceManager getResourceManagerM() {
        return net.pitan76.mcpitanlib.midohra.resource.ResourceManager.of(this.resourceManager);
    }

    public void putCompatibleRecipeEntry(ResourceLocation id, CompatibleRecipeEntry entry) {
        this.putCompatibleRecipeEntry(entry);
    }

    public void putCompatibleRecipeEntry(CompatibleRecipeEntry entry) {
        this.recipesById.put((Object)entry.getId(), entry.getRecipeEntry());
        this.recipesByType.put(entry.getType(), entry.getRecipeEntry());
    }

    public <T extends Recipe<?>> void putCompatibleRecipeEntry(CompatRecipeEntry<T> entry) {
        this.recipesById.put((Object)entry.getId(), entry.getRecipeEntry());
        this.recipesByType.put(entry.getType(), entry.getRecipeEntry());
    }

    public void putRecipeEntry(RecipeEntry entry) {
        this.recipesById.put((Object)entry.getId().toMinecraft(), entry.toMinecraft());
        this.recipesByType.put((Object)entry.getRawRecipeType(), entry.toMinecraft());
    }

    public void putRecipe(CompatRecipe recipe) {
        this.recipesById.put((Object)recipe.getId(), recipe.getRecipeEntry().getRecipeEntry());
        this.recipesByType.put(recipe.getType(), recipe.getRecipeEntry().getRecipeEntry());
    }
}

