/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.tag.item;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IngredientUtil;
import net.pitan76.mcpitanlib.api.util.item.ItemUtil;

public class RepairIngredientTag {
    public static final RepairIngredientTag REPAIRS_LEATHER_ARMOR = RepairIngredientTag.of("leather_armor_materials");
    public static final RepairIngredientTag REPAIRS_CHAIN_ARMOR = RepairIngredientTag.of("iron_tool_materials");
    public static final RepairIngredientTag REPAIRS_IRON_ARMOR = RepairIngredientTag.of("iron_tool_materials");
    public static final RepairIngredientTag REPAIRS_GOLD_ARMOR = RepairIngredientTag.of("golden_tool_materials");
    public static final RepairIngredientTag REPAIRS_DIAMOND_ARMOR = RepairIngredientTag.of("diamond_tool_materials");
    public static final RepairIngredientTag REPAIRS_NETHERITE_ARMOR = RepairIngredientTag.of("netherite_tool_materials");
    public static final RepairIngredientTag REPAIRS_TURTLE_HELMET = RepairIngredientTag.of("turtle_helmet_materials");
    public static final RepairIngredientTag REPAIRS_WOLF_ARMOR = RepairIngredientTag.of("leather_armor_materials");
    public static final RepairIngredientTag WOODEN_TOOL_MATERIALS = RepairIngredientTag.of("wooden_tool_materials");
    public static final RepairIngredientTag STONE_TOOL_MATERIALS = RepairIngredientTag.of("stone_tool_materials");
    public static final RepairIngredientTag IRON_TOOL_MATERIALS = RepairIngredientTag.of("iron_tool_materials");
    public static final RepairIngredientTag GOLDEN_TOOL_MATERIALS = RepairIngredientTag.of("golden_tool_materials");
    public static final RepairIngredientTag DIAMOND_TOOL_MATERIALS = RepairIngredientTag.of("diamond_tool_materials");
    public static final RepairIngredientTag NETHERITE_TOOL_MATERIALS = RepairIngredientTag.of("netherite_tool_materials");
    private TagKey<Item> tag;

    protected static RepairIngredientTag of(String path) {
        return new RepairIngredientTag(CompatIdentifier.of("mcpitanlib", path));
    }

    public RepairIngredientTag(CompatIdentifier identifier) {
        this.tag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier.toMinecraft());
    }

    @Deprecated
    public RepairIngredientTag(TagKey<Item> tag) {
        this.tag = tag;
    }

    @Deprecated
    public TagKey<Item> getTag() {
        return this.tag;
    }

    @Deprecated
    public Ingredient getIngredient() {
        return IngredientUtil.fromTagByIdentifier(this.tag.location());
    }

    public boolean contains(Item item) {
        if (item == null || this.tag == null) {
            return false;
        }
        return ItemUtil.isInTag(item, CompatIdentifier.fromMinecraft(this.tag.location()));
    }

    public boolean contains(ItemStack stack) {
        if (stack.isEmpty() || this.tag == null) {
            return false;
        }
        return this.getIngredient().test(stack);
    }
}

