/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class BufPayload
implements CustomPacketPayload {
    public final CustomPacketPayload.Type<BufPayload> ID;
    public byte[] data;
    private static final Map<CustomPacketPayload.Type<BufPayload>, StreamCodec<FriendlyByteBuf, BufPayload>> CODEC_CACHE = new HashMap<CustomPacketPayload.Type<BufPayload>, StreamCodec<FriendlyByteBuf, BufPayload>>();

    public BufPayload(byte[] data, CustomPacketPayload.Type<BufPayload> id) {
        this.data = data;
        this.ID = id;
        BufPayload.createCodec(id);
    }

    public BufPayload(FriendlyByteBuf buf, CustomPacketPayload.Type<BufPayload> id) {
        this(ByteBufUtil.getBytes((ByteBuf)buf), id);
    }

    public BufPayload(FriendlyByteBuf buf, ResourceLocation id) {
        this(ByteBufUtil.getBytes((ByteBuf)buf), BufPayload.id(id));
    }

    public byte[] getData() {
        return this.data;
    }

    public static StreamCodec<FriendlyByteBuf, BufPayload> getCodec(CustomPacketPayload.Type<BufPayload> id) {
        if (CODEC_CACHE.containsKey(id)) {
            return CODEC_CACHE.get(id);
        }
        return BufPayload.createCodec(id);
    }

    private static StreamCodec<FriendlyByteBuf, BufPayload> createCodec(CustomPacketPayload.Type<BufPayload> id) {
        StreamCodec codec = ByteBufCodecs.BYTE_ARRAY.map(data -> new BufPayload((byte[])data, id), BufPayload::getData).cast();
        CODEC_CACHE.put(id, (StreamCodec<FriendlyByteBuf, BufPayload>)codec);
        return codec;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return this.ID;
    }

    public static CustomPacketPayload.Type<BufPayload> id(ResourceLocation id) {
        if (CODEC_CACHE.isEmpty()) {
            return new CustomPacketPayload.Type(id);
        }
        for (CustomPacketPayload.Type<BufPayload> key : CODEC_CACHE.keySet()) {
            if (!key.id().equals((Object)id)) continue;
            return key;
        }
        return new CustomPacketPayload.Type(id);
    }
}

