/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.architectury.networking.transformers.PacketSink;
import me.shedaniel.architectury.networking.transformers.PacketTransformer;
import me.shedaniel.architectury.utils.Env;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class NetworkManager {
    public static void registerReceiver(Side side, ResourceLocation id, NetworkReceiver receiver) {
        me.shedaniel.architectury.networking.NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.sideConvert(side), (ResourceLocation)id, (buf, context) -> receiver.receive(buf, NetworkManager.contextConvert(context)));
    }

    @ApiStatus.Experimental
    public static void registerReceiver(Side side, ResourceLocation id, List<PacketTransformer> packetTransformers, NetworkReceiver receiver) {
        me.shedaniel.architectury.networking.NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.sideConvert(side), (ResourceLocation)id, packetTransformers, (buf, context) -> receiver.receive(buf, NetworkManager.contextConvert(context)));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static IPacket<?> toPacket(Side side, ResourceLocation id, PacketBuffer buf) {
        return me.shedaniel.architectury.networking.NetworkManager.toPacket((NetworkManager.Side)NetworkManager.sideConvert(side), (ResourceLocation)id, (PacketBuffer)buf);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static List<IPacket<?>> toPackets(Side side, ResourceLocation id, PacketBuffer buf) {
        return me.shedaniel.architectury.networking.NetworkManager.toPackets((NetworkManager.Side)NetworkManager.sideConvert(side), (ResourceLocation)id, (PacketBuffer)buf);
    }

    public static void collectPackets(PacketSink sink, Side side, ResourceLocation id, PacketBuffer buf) {
        me.shedaniel.architectury.networking.NetworkManager.collectPackets((PacketSink)sink, (NetworkManager.Side)NetworkManager.sideConvert(side), (ResourceLocation)id, (PacketBuffer)buf);
    }

    public static void sendToPlayer(ServerPlayerEntity player, ResourceLocation id, PacketBuffer buf) {
        me.shedaniel.architectury.networking.NetworkManager.sendToPlayer((ServerPlayerEntity)player, (ResourceLocation)id, (PacketBuffer)buf);
    }

    public static void sendToPlayers(Iterable<ServerPlayerEntity> players, ResourceLocation id, PacketBuffer buf) {
        me.shedaniel.architectury.networking.NetworkManager.sendToPlayers(players, (ResourceLocation)id, (PacketBuffer)buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation id, PacketBuffer buf) {
        me.shedaniel.architectury.networking.NetworkManager.sendToServer((ResourceLocation)id, (PacketBuffer)buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean canServerReceive(ResourceLocation id) {
        return me.shedaniel.architectury.networking.NetworkManager.canServerReceive((ResourceLocation)id);
    }

    public static boolean canPlayerReceive(ServerPlayerEntity player, ResourceLocation id) {
        return me.shedaniel.architectury.networking.NetworkManager.canPlayerReceive((ServerPlayerEntity)player, (ResourceLocation)id);
    }

    public static IPacket<?> createAddEntityPacket(Entity entity) {
        return me.shedaniel.architectury.networking.NetworkManager.createAddEntityPacket((Entity)entity);
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    @Nullable
    private static NetworkManager.Side sideConvert(Side side) {
        switch (side.ordinal()) {
            case 0: {
                return NetworkManager.Side.S2C;
            }
            case 1: {
                return NetworkManager.Side.C2S;
            }
        }
        return null;
    }

    private static PacketContext contextConvert(final NetworkManager.PacketContext context) {
        return new PacketContext(){

            @Override
            public PlayerEntity getPlayer() {
                return context.getPlayer();
            }

            @Override
            public void queue(Runnable runnable) {
                context.queue(runnable);
            }

            @Override
            public Env getEnvironment() {
                return context.getEnvironment();
            }
        };
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @FunctionalInterface
    public static interface NetworkReceiver {
        public void receive(PacketBuffer var1, PacketContext var2);
    }

    public static interface PacketContext {
        public PlayerEntity getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        default public Dist getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }
}

