/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.pitan76.mcpitanlib.api.util.client.render.VertexConsumerUtil;

public class DrawObjectMV {
    private final MatrixStack stack;
    private final IVertexBuilder buffer;
    public Matrix4f matrix4f;
    public Matrix3f matrix3f;

    public DrawObjectMV(MatrixStack stack, IVertexBuilder buffer) {
        this.stack = stack;
        this.buffer = buffer;
    }

    public DrawObjectMV(MatrixStack stack) {
        this(stack, null);
    }

    public DrawObjectMV(IVertexBuilder buffer) {
        this(null, buffer);
    }

    public MatrixStack getStack() {
        return this.stack;
    }

    public IVertexBuilder getBuffer() {
        return this.buffer;
    }

    public DrawObjectMV vertex(float x, float y, float z) {
        return VertexConsumerUtil.vertex(this, x, y, z);
    }

    public DrawObjectMV normal(float x, float y, float z) {
        return VertexConsumerUtil.normal(this, x, y, z);
    }

    public DrawObjectMV color(float red, float green, float blue, float alpha) {
        return VertexConsumerUtil.color(this, red, green, blue, alpha);
    }

    public DrawObjectMV color(int red, int green, int blue, int alpha) {
        return VertexConsumerUtil.color(this, red, green, blue, alpha);
    }

    public DrawObjectMV colorARGB(int argb) {
        return VertexConsumerUtil.colorARGB(this, argb);
    }

    public DrawObjectMV colorRGB(int rgb) {
        return VertexConsumerUtil.colorRGB(this, rgb);
    }

    public DrawObjectMV light(int light) {
        return VertexConsumerUtil.light(this, light);
    }

    public DrawObjectMV overlay(int overlay) {
        return VertexConsumerUtil.overlay(this, overlay);
    }

    public DrawObjectMV overlayDefaultUV() {
        return VertexConsumerUtil.overlayDefaultUV(this);
    }

    public Matrix4f getMatrix4f() {
        if (this.matrix4f == null) {
            this.matrix4f = this.stack.func_227866_c_().func_227870_a_();
        }
        return this.matrix4f;
    }

    public Matrix3f getMatrix3f() {
        if (this.matrix3f == null) {
            this.matrix3f = this.stack.func_227866_c_().func_227872_b_();
        }
        return this.matrix3f;
    }

    public DrawObjectMV vertexWithMatrix4f(float x, float y, float z) {
        VertexConsumerUtil.vertex(this.buffer, this.getMatrix4f(), x, y, z);
        return this;
    }

    public DrawObjectMV vertexWithMatrix(float x, float y, float z) {
        VertexConsumerUtil.vertex(this.buffer, this.stack, x, y, z);
        return this;
    }

    public DrawObjectMV normalWithMatrix(float x, float y, float z) {
        VertexConsumerUtil.normal(this.buffer, this.stack, x, y, z);
        return this;
    }

    public DrawObjectMV texture(float u, float v) {
        VertexConsumerUtil.texture(this.buffer, u, v);
        return this;
    }

    public DrawObjectMV next() {
        VertexConsumerUtil.next(this.buffer);
        return this;
    }

    public void renderQuad(float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ, int r, int g, int b, int alpha, int u, int v, int overlay, int light) {
        VertexConsumerUtil.renderQuad(this.buffer, this.stack, this.getMatrix4f(), this.getMatrix3f(), x1, y1, z1, x2, y2, z2, normalX, normalY, normalZ, r, g, b, alpha, u, v, overlay, light);
    }
}

