/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.render.block.entity.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.pitan76.mcpitanlib.api.client.render.CompatRenderLayer;
import net.pitan76.mcpitanlib.api.client.render.DrawObjectMV;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.MathUtil;
import net.pitan76.mcpitanlib.api.util.client.ClientUtil;
import net.pitan76.mcpitanlib.api.util.client.MatrixStackUtil;

public class BlockEntityRenderEvent<T extends CompatBlockEntity> {
    public T blockEntity;
    public float tickDelta;
    public MatrixStack matrices;
    public IRenderTypeBuffer vertexConsumers;
    int light;
    int overlay;
    public Matrix4f matrix4f;
    public Matrix3f matrix3f;

    public BlockEntityRenderEvent(T blockEntity, float tickDelta, MatrixStack matrices, IRenderTypeBuffer vertexConsumers, int light, int overlay) {
        this.blockEntity = blockEntity;
        this.tickDelta = tickDelta;
        this.matrices = matrices;
        this.vertexConsumers = vertexConsumers;
        this.light = light;
        this.overlay = overlay;
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public MatrixStack getMatrices() {
        return this.matrices;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public int getLight() {
        return this.light;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public IVertexBuilder getVertexConsumer(RenderType layer) {
        return this.vertexConsumers.getBuffer(layer);
    }

    public IVertexBuilder getVertexConsumer(CompatRenderLayer layer) {
        return this.getVertexConsumer(layer.raw());
    }

    public IRenderTypeBuffer getVertexConsumers() {
        return this.vertexConsumers;
    }

    public void push() {
        MatrixStackUtil.push(this.matrices);
    }

    public void translate(double x, double y, double z) {
        MatrixStackUtil.translate(this.matrices, x, y, z);
    }

    public void pop() {
        MatrixStackUtil.pop(this.matrices);
    }

    public void multiply(MathUtil.RotationAxisType type, float deg) {
        MatrixStackUtil.multiply(this.matrices, type, deg);
    }

    public void scale(float x, float y, float z) {
        MatrixStackUtil.scale(this.matrices, x, y, z);
    }

    public ItemRenderer getItemRenderer() {
        return ClientUtil.getItemRenderer();
    }

    public boolean isRemoved() {
        return this.blockEntity.func_145837_r();
    }

    public DrawObjectMV getDrawObject(CompatRenderLayer layer) {
        return new DrawObjectMV(this.getMatrices(), this.getVertexConsumer(layer));
    }

    public Matrix4f getMatrix4f() {
        if (this.matrix4f == null) {
            this.matrix4f = this.matrices.func_227866_c_().func_227870_a_();
        }
        return this.matrix4f;
    }

    public Matrix3f getMatrix3f() {
        if (this.matrix3f == null) {
            this.matrix3f = this.matrices.func_227866_c_().func_227872_b_();
        }
        return this.matrix3f;
    }

    public BlockPos getPos() {
        return ((CompatBlockEntity)((Object)this.blockEntity)).callGetPos();
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getPos());
    }
}

