/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import me.shedaniel.architectury.registry.menu.ExtendedMenuProvider;
import net.minecraft.block.BlockState;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffect;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffectInstance;
import net.pitan76.mcpitanlib.api.gui.ExtendedNamedScreenHandlerFactory;
import net.pitan76.mcpitanlib.api.item.CompatFoodComponent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ScreenHandlerUtil;
import net.pitan76.mcpitanlib.core.player.ItemCooldown;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;

public class Player {
    private final PlayerEntity entity;
    public ItemCooldown itemCooldown = new ItemCooldown(this);

    public PlayerEntity getEntity() {
        return this.entity;
    }

    public PlayerEntity getPlayerEntity() {
        return this.getEntity();
    }

    public Player(PlayerEntity playerEntity) {
        this.entity = playerEntity;
    }

    public PlayerInventory getInv() {
        return this.getEntity().field_71071_by;
    }

    public PlayerInventory getInventory() {
        return this.getInv();
    }

    public NonNullList<net.minecraft.item.ItemStack> getArmor() {
        return this.getInv().field_70460_b;
    }

    public NonNullList<net.minecraft.item.ItemStack> getMain() {
        return this.getInv().field_70462_a;
    }

    public NonNullList<net.minecraft.item.ItemStack> getOffHand() {
        return this.getInv().field_184439_c;
    }

    public int getSelectSlot() {
        return this.getInv().field_70461_c;
    }

    public int getInvSize() {
        return this.getInv().func_70302_i_();
    }

    public OptionalInt openGuiScreen(INamedContainerProvider factory) {
        return this.getEntity().func_213829_a(factory);
    }

    public OptionalInt openGuiScreen(World world, BlockState state, BlockPos pos) {
        return this.openGuiScreen(state.func_215699_b(world, pos));
    }

    public boolean isServerPlayerEntity() {
        return this.getEntity() instanceof ServerPlayerEntity;
    }

    public void openExtendedMenu(INamedContainerProvider provider, Consumer<PacketBuffer> bufWriter) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openExtendedMenu((ServerPlayerEntity)this.getPlayerEntity(), provider, bufWriter);
        }
    }

    public void openExtendedMenu(ExtendedMenuProvider provider) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openExtendedMenu((ServerPlayerEntity)this.getPlayerEntity(), provider);
        }
    }

    public void openExtendedMenu(ExtendedNamedScreenHandlerFactory provider) {
        this.openExtendedMenu((ExtendedMenuProvider)provider);
    }

    public void openMenu(INamedContainerProvider provider) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openMenu((ServerPlayerEntity)this.getPlayerEntity(), provider);
        }
    }

    public void insertStack(net.minecraft.item.ItemStack stack) {
        this.getInv().func_70441_a(stack);
    }

    public void insertStack(int slot, net.minecraft.item.ItemStack stack) {
        this.getInv().func_191971_c(slot, stack);
    }

    public void offerOrDrop(net.minecraft.item.ItemStack itemStack) {
        this.getInv().func_191975_a(this.getWorld(), itemStack);
    }

    public void giveStack(net.minecraft.item.ItemStack stack) {
        this.getEntity().func_191521_c(stack);
    }

    public String getName() {
        return this.getEntity().func_200200_C_().getString();
    }

    public UUID getUUID() {
        return this.getEntity().func_110124_au();
    }

    public PlayerAbilities getAbilities() {
        return this.getEntity().field_71075_bZ;
    }

    public boolean isCreative() {
        return this.getAbilities().field_75098_d;
    }

    public boolean isFlying() {
        return this.getAbilities().field_75100_b;
    }

    public boolean isInvulnerable() {
        return this.getAbilities().field_75102_a;
    }

    public World getWorld() {
        return this.getEntity().field_70170_p;
    }

    public Container getCurrentScreenHandler() {
        return this.getEntity().field_71070_bA;
    }

    public boolean isSneaking() {
        return this.getEntity().func_225608_bj_();
    }

    public net.minecraft.item.ItemStack getCursorStack() {
        return this.getInv().func_70445_o();
    }

    public boolean isClient() {
        return this.getWorld().func_201670_d();
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public void readCustomDataFromNbt(CompoundNBT nbt) {
        this.getEntity().func_70037_a(nbt);
    }

    public void writeCustomDataToNbt(CompoundNBT nbt) {
        this.getEntity().func_213281_b(nbt);
    }

    public void sendMessage(ITextComponent text) {
        this.getEntity().func_146105_b(text, false);
    }

    public void sendActionBar(ITextComponent text) {
        this.getEntity().func_146105_b(text, true);
    }

    public void equipStack(EquipmentSlotType slot, net.minecraft.item.ItemStack stack) {
        this.getEntity().func_184201_a(slot, stack);
    }

    public void dropStack(net.minecraft.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        this.getEntity().func_146097_a(stack, throwRandomly, retainOwnership);
    }

    public void dropStack(net.minecraft.item.ItemStack stack, boolean retainOwnership) {
        this.dropStack(stack, false, retainOwnership);
    }

    public void dropStack(net.minecraft.item.ItemStack stack) {
        this.dropStack(stack, false, false);
    }

    public BlockPos getBlockPos() {
        return this.getEntity().func_233580_cy_();
    }

    public Vector3d getPos() {
        return this.getEntity().func_213303_ch();
    }

    public net.minecraft.item.ItemStack getStackInHand(Hand hand) {
        return this.getEntity().func_184586_b(hand);
    }

    public void heal(float amount) {
        this.getEntity().func_70691_i(amount);
    }

    public float getYaw() {
        return this.getEntity().func_195046_g(1.0f);
    }

    public float getPitch() {
        return this.getEntity().func_195050_f(1.0f);
    }

    public void playSound(SoundEvent event, SoundCategory category, float volume, float pitch) {
        Optional<ServerPlayerEntity> player;
        if (this.isServerPlayerEntity() && (player = this.getServerPlayer()).isPresent()) {
            player.get().func_213823_a(event, category, volume, pitch);
            return;
        }
        this.playSound(event, volume, pitch);
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        Optional<ServerPlayerEntity> player;
        if (this.isServerPlayerEntity() && (player = this.getServerPlayer()).isPresent()) {
            player.get().func_184185_a(event, volume, pitch);
            return;
        }
        this.getEntity().func_184185_a(event, volume, pitch);
    }

    public void playSound(CompatSoundEvent event, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(event.get(), category.get(), volume, pitch);
    }

    public void playSound(CompatSoundEvent event, float volume, float pitch) {
        this.playSound(event.get(), volume, pitch);
    }

    public ItemCooldown getItemCooldown() {
        return this.itemCooldown;
    }

    public CooldownTracker getItemCooldownManager() {
        return this.getEntity().func_184811_cZ();
    }

    public void incrementStat(Stat<?> stat) {
        this.getEntity().func_71029_a(stat);
    }

    public <T> void incrementStat(StatType<T> type, T object) {
        this.getEntity().func_71029_a(type.func_199076_b(object));
    }

    public void incrementStat(ResourceLocation id) {
        this.getEntity().func_195066_a(id);
    }

    public void incrementStat(CompatIdentifier id) {
        this.getEntity().func_195066_a(id.toMinecraft());
    }

    public void teleport(double x, double y, double z) {
        this.getEntity().func_213373_a(x, y, z, false);
    }

    public net.minecraft.item.ItemStack getMainHandStack() {
        return this.getStackInHand(Hand.MAIN_HAND);
    }

    public net.minecraft.item.ItemStack getOffHandStack() {
        return this.getStackInHand(Hand.OFF_HAND);
    }

    public Direction getHorizontalFacing() {
        return this.getEntity().func_174811_aO();
    }

    public double getX() {
        return this.getEntity().func_226277_ct_();
    }

    public double getY() {
        return this.getEntity().func_226278_cu_();
    }

    public double getZ() {
        return this.getEntity().func_226281_cx_();
    }

    public boolean isServerPlayer() {
        return this.getEntity() instanceof ServerPlayerEntity;
    }

    public Optional<ServerPlayerEntity> getServerPlayer() {
        if (this.isServerPlayer()) {
            return Optional.of((ServerPlayerEntity)this.getEntity());
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<ClientPlayerEntity> getClientPlayer() {
        if (this.getEntity() instanceof ClientPlayerEntity) {
            return Optional.of((ClientPlayerEntity)this.getEntity());
        }
        return Optional.empty();
    }

    public void setVelocity(double x, double y, double z) {
        this.getEntity().func_213293_j(x, y, z);
    }

    public void setVelocity(Vector3d velocity) {
        this.getEntity().func_213317_d(velocity);
    }

    public Vector3d getVelocity() {
        return this.getEntity().func_213322_ci();
    }

    public Optional<ServerPlayNetHandler> getNetworkHandler() {
        Optional<ServerPlayerEntity> player = this.getServerPlayer();
        return player.map(sp -> sp.field_71135_a);
    }

    public boolean hasNetworkHandler() {
        return this.getNetworkHandler().isPresent();
    }

    public boolean isSpectator() {
        return this.getEntity().func_175149_v();
    }

    public Optional<net.minecraft.item.ItemStack> getCurrentHandItem() {
        boolean playerIsHoldingInOffHand;
        boolean playerIsHoldingInMainHand;
        boolean bl = playerIsHoldingInMainHand = !this.getMainHandStack().func_190926_b();
        if (playerIsHoldingInMainHand) {
            return Optional.ofNullable(this.getMainHandStack());
        }
        boolean bl2 = playerIsHoldingInOffHand = !this.getOffHandStack().func_190926_b();
        if (playerIsHoldingInOffHand) {
            return Optional.ofNullable(this.getOffHandStack());
        }
        return Optional.empty();
    }

    public void addStatusEffect(CompatStatusEffectInstance effect) {
        this.getEntity().func_195064_c(effect.getInstance());
    }

    public void removeStatusEffect(CompatStatusEffect effect) {
        this.getEntity().func_195063_d(effect.getStatusEffect(this.getWorld()));
    }

    public List<CompatStatusEffectInstance> getStatusEffects() {
        ArrayList<CompatStatusEffectInstance> compatEffects = new ArrayList<CompatStatusEffectInstance>();
        for (EffectInstance effect : this.getEntity().func_70651_bq()) {
            compatEffects.add(new CompatStatusEffectInstance(effect));
        }
        return compatEffects;
    }

    public void addExperience(int experience) {
        this.getEntity().func_195068_e(experience);
    }

    public int getExperienceLevel() {
        return this.getEntity().field_71068_ca;
    }

    public void addExperienceLevels(int levels) {
        this.getEntity().func_82242_a(levels);
    }

    public void setExperienceLevel(int level) {
        this.getEntity().field_71068_ca = level;
    }

    public void addScore(int score) {
        this.getEntity().func_85039_t(score);
    }

    public int getScore() {
        return this.getEntity().func_71037_bA();
    }

    public void setScore(int score) {
        this.getEntity().func_85040_s(score);
    }

    public int getTotalExperience() {
        return this.getEntity().field_71067_cb;
    }

    public void setTotalExperience(int experience) {
        this.getEntity().field_71067_cb = experience;
    }

    public boolean isSwimming() {
        return this.getEntity().func_203007_ba();
    }

    public void setStackInHand(Hand hand, net.minecraft.item.ItemStack stack) {
        this.getEntity().func_184611_a(hand, stack);
    }

    public void setStackInHand(Hand hand, ItemStack stack) {
        this.setStackInHand(hand, stack.toMinecraft());
    }

    public ItemStack getMidohraStackInHand(Hand hand) {
        return ItemStack.of(this.getStackInHand(hand));
    }

    public Hand getActiveHand() {
        return this.getEntity().func_184600_cs();
    }

    public float getBlockBreakingSpeed(BlockState state) {
        return this.getEntity().func_184813_a(state);
    }

    public boolean canHarvest(BlockState state) {
        return this.getEntity().func_234569_d_(state);
    }

    public net.pitan76.mcpitanlib.midohra.world.World getMidohraWorld() {
        return net.pitan76.mcpitanlib.midohra.world.World.of(this.getWorld());
    }

    public void eatFood(net.minecraft.item.ItemStack stack, CompatFoodComponent foodComponent) {
        this.getEntity().func_213357_a(this.getWorld(), stack);
    }
}

