/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;

public class BlockUseEvent
extends BaseEvent {
    public net.minecraft.block.BlockState state;
    public World world;
    public BlockPos pos;
    public Player player;
    public Hand hand;
    public BlockRayTraceResult hit;
    public ItemStack stack;

    public BlockUseEvent(net.minecraft.block.BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.player = new Player(player);
        this.hand = hand;
        this.hit = hit;
        this.stack = this.player.getStackInHand(hand);
    }

    public BlockRayTraceResult getHit() {
        return this.hit;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Hand getHand() {
        return this.hand;
    }

    public World getWorld() {
        return this.world;
    }

    public net.minecraft.block.BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isClient() {
        return this.world.func_201670_d();
    }

    public CompatActionResult success() {
        return CompatActionResult.SUCCESS;
    }

    public CompatActionResult fail() {
        return CompatActionResult.FAIL;
    }

    public CompatActionResult pass() {
        return CompatActionResult.PASS;
    }

    public CompatActionResult consume() {
        return CompatActionResult.CONSUME;
    }

    public boolean hasBlockEntity() {
        return WorldUtil.hasBlockEntity(this.world, this.pos);
    }

    public TileEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.pos);
    }

    public boolean isSneaking() {
        return this.player.isSneaking();
    }

    public net.pitan76.mcpitanlib.midohra.world.World getMidohraWorld() {
        return net.pitan76.mcpitanlib.midohra.world.World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    public BlockState getMidohraState() {
        return BlockState.of(this.state);
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.pos);
    }

    public BlockWrapper getBlockWrapper() {
        return BlockWrapper.of(this.state.func_177230_c());
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }
}

