/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.event.block.StateReplacedEvent;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class ItemScattererUtil {
    public static void spawn(World world, BlockPos pos, TileEntity blockEntity) {
        if (blockEntity instanceof IInventory) {
            ItemScattererUtil.spawn(world, pos, (IInventory)blockEntity);
        }
    }

    public static void spawn(World world, BlockPos pos, IInventory inventory) {
        InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inventory);
    }

    public static void spawn(World world, BlockPos pos, ItemStack stack) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
    }

    public static void spawn(World world, BlockPos pos, NonNullList<ItemStack> stacks) {
        InventoryHelper.func_219961_a((World)world, (BlockPos)pos, stacks);
    }

    public static void onStateReplaced(StateReplacedEvent e) {
        ItemScattererUtil.onStateReplaced(e.getState(), e.getNewState(), e.getWorld(), e.getPos());
    }

    public static void onStateReplaced(BlockState state, BlockState newState, World world, BlockPos pos) {
        if (state.func_203425_a(newState.func_177230_c())) {
            return;
        }
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity instanceof IInventory) {
            ItemScattererUtil.spawn(world, pos, (IInventory)blockEntity);
            WorldUtil.updateComparators(world, pos, state.func_177230_c());
        }
    }

    public static void spawn(net.pitan76.mcpitanlib.midohra.world.World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, ItemStack stack) {
        ItemScattererUtil.spawn(world.getRaw(), pos.toMinecraft(), stack);
    }

    public static void spawn(net.pitan76.mcpitanlib.midohra.world.World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, NonNullList<ItemStack> stacks) {
        ItemScattererUtil.spawn(world.getRaw(), pos.toMinecraft(), stacks);
    }

    public static void spawn(net.pitan76.mcpitanlib.midohra.world.World world, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, IInventory inventory) {
        ItemScattererUtil.spawn(world.getRaw(), pos.toMinecraft(), inventory);
    }
}

