/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.item;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import org.jetbrains.annotations.Nullable;

public class ItemUseOnBlockEvent
extends BaseEvent {
    public Player player;
    public Hand hand;
    public BlockRayTraceResult hit;
    public ItemStack stack;
    public World world;
    public BlockPos blockPos;

    public ItemUseOnBlockEvent(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        this(player.field_70170_p, player, hand, player.func_184586_b(hand), hit);
    }

    public ItemUseOnBlockEvent(World world, @Nullable PlayerEntity player, Hand hand, ItemStack stack, BlockRayTraceResult hit) {
        if (player != null) {
            this.player = new Player(player);
        }
        this.hand = hand;
        this.hit = hit;
        this.stack = stack;
        this.world = world;
        this.blockPos = hit.func_216350_a();
    }

    public ItemUseOnBlockEvent(Player player, Hand hand, BlockRayTraceResult hit) {
        this(player.getWorld(), player.getEntity(), hand, player.getStackInHand(hand), hit);
    }

    public ItemUseContext toIUC() {
        return new ItemUseContext(this.player.getPlayerEntity(), this.hand, this.hit);
    }

    public boolean isClient() {
        return this.world.func_201670_d();
    }

    public Player getPlayer() {
        return this.player;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockRayTraceResult getHit() {
        return this.hit;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Hand getHand() {
        return this.hand;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public CompatActionResult success() {
        return CompatActionResult.SUCCESS;
    }

    public CompatActionResult fail() {
        return CompatActionResult.FAIL;
    }

    public CompatActionResult pass() {
        return CompatActionResult.PASS;
    }

    public CompatActionResult consume() {
        return CompatActionResult.CONSUME;
    }

    public TileEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.blockPos);
    }

    public boolean hasBlockEntity() {
        return WorldUtil.hasBlockEntity(this.world, this.blockPos);
    }

    public net.minecraft.block.BlockState getBlockState() {
        return WorldUtil.getBlockState(this.world, this.blockPos);
    }

    public Vector3d getPos() {
        return this.hit.func_216347_e();
    }

    public Direction getSide() {
        return this.hit.func_216354_b();
    }

    public net.pitan76.mcpitanlib.midohra.world.World getMidohraWorld() {
        return net.pitan76.mcpitanlib.midohra.world.World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    public BlockState getMidohraState() {
        return BlockState.of(this.getBlockState());
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getBlockPos());
    }

    public BlockWrapper getBlockWrapper() {
        return this.getMidohraState().getBlock();
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }
}

