/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.stack;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;

public class LoreUtil {
    public static boolean hasLore(ItemStack stack) {
        return stack.func_179543_a("display") != null && stack.func_179543_a("display").func_74764_b("Lore");
    }

    public static List<ITextComponent> getLore(ItemStack stack) {
        if (!LoreUtil.hasLore(stack)) {
            return new ArrayList<ITextComponent>();
        }
        return NbtUtil.getList(stack.func_179543_a("display"), "Lore", 8).stream().map(nbt -> {
            String str = NbtUtil.asString(nbt);
            if (str == null) {
                return TextUtil.empty();
            }
            Pattern pattern = Pattern.compile("\"text\":\"([^\"]+)\"");
            Matcher matcher = pattern.matcher(str);
            if (matcher.find()) {
                String text = matcher.group(1);
                return ITextComponent.func_244388_a((String)text);
            }
            return ITextComponent.func_244388_a((String)str);
        }).collect(Collectors.toList());
    }

    public static List<String> getLoreAsStringList(ItemStack stack) {
        return LoreUtil.getLore(stack).stream().map(ITextComponent::getString).collect(Collectors.toList());
    }

    public static String getLoreAsString(ItemStack stack) {
        return LoreUtil.getLoreAsStringList(stack).stream().reduce("", (a, b) -> a + "\n" + b);
    }

    public static void setLore(ItemStack stack, List<ITextComponent> lore) {
        ListNBT nbtList = NbtUtil.createNbtList();
        for (ITextComponent text : lore) {
            String str = text.getString();
            str = "{\"text\":\"" + str + "\"}";
            nbtList.add((Object)NbtUtil.createString(str));
        }
        CompoundNBT displayNbt = stack.func_190925_c("display");
        displayNbt.func_218657_a("Lore", (INBT)nbtList);
        stack.func_77983_a("display", (INBT)displayNbt);
    }

    public static void setLoreStringList(ItemStack stack, List<String> lore) {
        LoreUtil.setLore(stack, lore.stream().map(ITextComponent::func_244388_a).collect(Collectors.toList()));
    }

    public static void setLore(ItemStack stack, String lore) {
        ArrayList<ITextComponent> loreList = new ArrayList<ITextComponent>();
        for (String line : lore.split("\n")) {
            loreList.add(ITextComponent.func_244388_a((String)line));
        }
        LoreUtil.setLore(stack, loreList);
    }
}

