/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;

public class PacketByteUtil {
    public static PacketBuffer create() {
        return new PacketBuffer(Unpooled.buffer());
    }

    public static PacketBuffer empty() {
        return new PacketBuffer(Unpooled.EMPTY_BUFFER);
    }

    public static <K, V> Map<K, V> readMap(PacketBuffer buf, Function<PacketBuffer, K> keyParser, Function<PacketBuffer, V> valueParser) {
        CompoundNBT nbt = buf.func_244273_m();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (String key_v : Objects.requireNonNull(nbt).func_150296_c()) {
            Object k;
            Object v;
            if (key_v.endsWith("_t") || key_v.endsWith("_k")) continue;
            String key = key_v.substring(0, key_v.length() - 2);
            String key_t = key + "_t";
            key_v = key + "_v";
            switch (key_t) {
                case "int": {
                    v = nbt.func_74762_e(key_v);
                    break;
                }
                case "str": {
                    v = nbt.func_74779_i(key_v);
                    break;
                }
                case "short": {
                    v = nbt.func_74765_d(key_v);
                    break;
                }
                case "long": {
                    v = nbt.func_74763_f(key_v);
                    break;
                }
                case "float": {
                    v = Float.valueOf(nbt.func_74760_g(key_v));
                    break;
                }
                case "byte": {
                    v = nbt.func_74771_c(key_v);
                    break;
                }
                case "double": {
                    v = nbt.func_74769_h(key_v);
                    break;
                }
                case "bool": {
                    v = nbt.func_74767_n(key_v);
                    break;
                }
                case "uuid": {
                    v = nbt.func_186857_a(key_v);
                    break;
                }
                case "text": {
                    v = TextUtil.literal(nbt.func_74779_i(key_v));
                    break;
                }
                case "itemstack": {
                    v = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l(key_v));
                    break;
                }
                case "identifier": {
                    v = new ResourceLocation(nbt.func_74779_i(key_v));
                    break;
                }
                case "map": {
                    v = key_v;
                    break;
                }
                default: {
                    v = null;
                }
            }
            switch (nbt.func_74779_i("type_k")) {
                case "int": {
                    k = Integer.valueOf(key);
                    break;
                }
                case "str": {
                    k = key;
                    break;
                }
                case "short": {
                    k = Short.valueOf(key);
                    break;
                }
                case "long": {
                    k = Long.valueOf(key);
                    break;
                }
                case "float": {
                    k = Float.valueOf(key);
                    break;
                }
                case "byte": {
                    k = Byte.valueOf(key);
                    break;
                }
                case "double": {
                    k = Double.valueOf(key);
                    break;
                }
                case "bool": {
                    k = Boolean.valueOf(key);
                    break;
                }
                case "uuid": {
                    k = UUID.fromString(key);
                    break;
                }
                case "text": {
                    k = TextUtil.literal(key);
                    break;
                }
                case "identifier": {
                    k = new ResourceLocation(key);
                    break;
                }
                default: {
                    k = null;
                }
            }
            if (k == null || v == null) continue;
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> void writeMap(PacketBuffer buf, Map<K, V> map) {
        PacketByteUtil.writeMap(buf, map, PacketByteUtil::writeVar, PacketByteUtil::writeVar);
    }

    public static <K, V> void writeMap(PacketBuffer buf, Map<K, V> map, BiConsumer<PacketBuffer, K> keySerializer, BiConsumer<PacketBuffer, V> valueSerializer) {
        CompoundNBT nbt = new CompoundNBT();
        Object lastK = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K k = entry.getKey();
            V v = entry.getValue();
            lastK = k;
            String key = k.toString();
            if (v instanceof Integer) {
                nbt.func_74768_a(key + "_v", ((Integer)v).intValue());
                nbt.func_74778_a(key + "_t", "int");
            }
            if (v instanceof String) {
                nbt.func_74778_a(key, (String)v);
                nbt.func_74778_a(key + "_t", "str");
            }
            if (v instanceof Long) {
                nbt.func_74772_a(key, ((Long)v).longValue());
                nbt.func_74778_a(key + "_t", "long");
            }
            if (v instanceof Short) {
                nbt.func_74777_a(key, ((Short)v).shortValue());
                nbt.func_74778_a(key + "_t", "short");
            }
            if (v instanceof Double) {
                nbt.func_74780_a(key, ((Double)v).doubleValue());
                nbt.func_74778_a(key + "_t", "double");
            }
            if (v instanceof Boolean) {
                nbt.func_74757_a(key, ((Boolean)v).booleanValue());
                nbt.func_74778_a(key + "_t", "bool");
            }
            if (v instanceof Float) {
                nbt.func_74776_a(key, ((Float)v).floatValue());
                nbt.func_74778_a(key + "_t", "float");
            }
            if (v instanceof Byte) {
                nbt.func_74774_a(key, ((Byte)v).byteValue());
                nbt.func_74778_a(key + "_t", "byte");
            }
            if (v instanceof UUID) {
                nbt.func_186854_a(key, (UUID)v);
                nbt.func_74778_a(key + "_t", "uuid");
            }
            if (v instanceof ITextComponent) {
                nbt.func_74778_a(key, ((ITextComponent)v).getString());
                nbt.func_74778_a(key + "_t", "text");
            }
            if (v instanceof ItemStack) {
                CompoundNBT stackNbt = new CompoundNBT();
                ((ItemStack)v).func_77955_b(stackNbt);
                nbt.func_218657_a(key, (INBT)stackNbt);
                nbt.func_74778_a(key + "_t", "itemstack");
            }
            if (!(v instanceof ResourceLocation)) continue;
            nbt.func_74778_a(key, v.toString());
            nbt.func_74778_a(key + "_t", "identifier");
        }
        if (lastK == null) {
            return;
        }
        if (lastK instanceof Integer) {
            nbt.func_74778_a("type_k", "int");
        }
        if (lastK instanceof String) {
            nbt.func_74778_a("type_k", "str");
        }
        if (lastK instanceof Long) {
            nbt.func_74778_a("type_k", "long");
        }
        if (lastK instanceof Short) {
            nbt.func_74778_a("type_k", "short");
        }
        if (lastK instanceof Double) {
            nbt.func_74778_a("type_k", "double");
        }
        if (lastK instanceof Boolean) {
            nbt.func_74778_a("type_k", "bool");
        }
        if (lastK instanceof Float) {
            nbt.func_74778_a("type_k", "float");
        }
        if (lastK instanceof Byte) {
            nbt.func_74778_a("type_k", "byte");
        }
        if (lastK instanceof UUID) {
            nbt.func_74778_a("type_k", "uuid");
        }
        if (lastK instanceof ITextComponent) {
            nbt.func_74778_a("type_k", "text");
        }
        if (lastK instanceof ItemStack) {
            nbt.func_74778_a("type_k", "itemstack");
        }
        if (lastK instanceof ResourceLocation) {
            nbt.func_74778_a("type_k", "identifier");
        }
        buf.func_150786_a(nbt);
    }

    public static void writeVar(PacketBuffer buf, Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            buf.func_180714_a(s);
        }
        if (obj instanceof Integer) {
            int i = (Integer)obj;
            buf.writeInt(i);
        }
        if (obj instanceof Long) {
            long l = (Long)obj;
            buf.writeLong(l);
        }
        if (obj instanceof Short) {
            short s = (Short)obj;
            buf.writeShort((int)s);
        }
        if (obj instanceof Boolean) {
            boolean b = (Boolean)obj;
            buf.writeBoolean(b);
        }
        if (obj instanceof Byte) {
            byte b = (Byte)obj;
            buf.writeByte((int)b);
        }
        if (obj instanceof CompoundNBT) {
            CompoundNBT nbt = (CompoundNBT)obj;
            buf.func_150786_a(nbt);
        }
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            buf.func_150788_a(stack);
        }
        if (obj instanceof ResourceLocation) {
            ResourceLocation identifier = (ResourceLocation)obj;
            buf.func_192572_a(identifier);
        }
        if (obj instanceof Float) {
            Float f = (Float)obj;
            buf.writeFloat(f.floatValue());
        }
        if (obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            buf.func_179252_a(uuid);
        }
        if (obj instanceof ITextComponent) {
            ITextComponent text = (ITextComponent)obj;
            buf.func_179256_a(text);
        }
        if (obj instanceof BlockPos) {
            BlockPos pos = (BlockPos)obj;
            buf.func_179255_a(pos);
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            PacketByteUtil.writeMap(buf, map);
        }
    }

    public static PacketBuffer writeNbt(PacketBuffer buf, CompoundNBT nbt) {
        return buf.func_150786_a(nbt);
    }

    public static CompoundNBT readNbt(PacketBuffer buf) {
        return buf.func_150793_b();
    }

    public static PacketBuffer writeItemStack(PacketBuffer buf, ItemStack stack) {
        return buf.func_150788_a(stack);
    }

    public static ItemStack readItemStack(PacketBuffer buf) {
        return buf.func_150791_c();
    }

    public static PacketBuffer writeIdentifier(PacketBuffer buf, ResourceLocation identifier) {
        return buf.func_192572_a(identifier);
    }

    public static ResourceLocation readIdentifier(PacketBuffer buf) {
        return buf.func_192575_l();
    }

    public static PacketBuffer writeText(PacketBuffer buf, ITextComponent text) {
        return buf.func_179256_a(text);
    }

    public static ITextComponent readText(PacketBuffer buf) {
        return buf.func_179258_d();
    }

    public static PacketBuffer writeBlockPos(PacketBuffer buf, BlockPos pos) {
        return buf.func_179255_a(pos);
    }

    public static BlockPos readBlockPos(PacketBuffer buf) {
        return buf.func_179259_c();
    }

    public static PacketBuffer writeUuid(PacketBuffer buf, UUID uuid) {
        return buf.func_179252_a(uuid);
    }

    public static UUID readUuid(PacketBuffer buf) {
        return buf.func_179253_g();
    }

    public static PacketBuffer writeVarInt(PacketBuffer buf, int i) {
        return buf.func_150787_b(i);
    }

    public static int readVarInt(PacketBuffer buf) {
        return buf.func_150792_a();
    }

    public static PacketBuffer writeVarLong(PacketBuffer buf, long l) {
        return buf.func_179254_b(l);
    }

    public static long readVarLong(PacketBuffer buf) {
        return buf.func_179260_f();
    }

    public static ByteBuf writeBoolean(PacketBuffer buf, boolean b) {
        return buf.writeBoolean(b);
    }

    public static boolean readBoolean(PacketBuffer buf) {
        return buf.readBoolean();
    }

    public static ByteBuf writeByte(PacketBuffer buf, byte b) {
        return buf.writeByte((int)b);
    }

    public static byte readByte(PacketBuffer buf) {
        return buf.readByte();
    }

    public static ByteBuf writeShort(PacketBuffer buf, short s) {
        return buf.writeShort((int)s);
    }

    public static short readShort(PacketBuffer buf) {
        return buf.readShort();
    }

    public static ByteBuf writeInt(PacketBuffer buf, int i) {
        return buf.writeInt(i);
    }

    public static int readInt(PacketBuffer buf) {
        return buf.readInt();
    }

    public static ByteBuf writeLong(PacketBuffer buf, long l) {
        return buf.writeLong(l);
    }

    public static long readLong(PacketBuffer buf) {
        return buf.readLong();
    }

    public static ByteBuf writeFloat(PacketBuffer buf, float f) {
        return buf.writeFloat(f);
    }

    public static float readFloat(PacketBuffer buf) {
        return buf.readFloat();
    }

    public static ByteBuf writeDouble(PacketBuffer buf, double d) {
        return buf.writeDouble(d);
    }

    public static double readDouble(PacketBuffer buf) {
        return buf.readDouble();
    }

    public static PacketBuffer writeByteArray(PacketBuffer buf, byte[] bytes) {
        return buf.func_179250_a(bytes);
    }

    public static byte[] readByteArray(PacketBuffer buf) {
        return buf.func_179251_a();
    }

    public static PacketBuffer writeString(PacketBuffer buf, String s) {
        return buf.func_180714_a(s);
    }

    public static String readString(PacketBuffer buf) {
        return buf.func_218666_n();
    }

    public static PacketBuffer writeIntArray(PacketBuffer buf, int[] ints) {
        return buf.func_186875_a(ints);
    }

    public static int[] readIntArray(PacketBuffer buf) {
        return buf.func_186863_b();
    }

    public static PacketBuffer writeLongArray(PacketBuffer buf, long[] longs) {
        return buf.func_186865_a(longs);
    }

    public static long[] readLongArray(PacketBuffer buf) {
        long[] longs = new long[buf.readableBytes() / 8];
        return buf.func_186873_b(longs);
    }

    public static INBT readUnlimitedNbt(PacketBuffer buf) {
        return buf.func_244272_a(new NBTSizeTracker(Long.MAX_VALUE));
    }
}

