/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class TextConverter {
    public static IFormattableTextComponent convert(String string) {
        return TextConverter.convert(string, false);
    }

    public static IFormattableTextComponent convert(String text, boolean translatable) {
        String[] splits = TextConverter.split(text);
        StringTextComponent result = new StringTextComponent("");
        TextFormatting[] currentFormatting = new TextFormatting[]{};
        for (String part : splits) {
            if (part.startsWith("\u00a7") && part.length() == 2) {
                char code = part.charAt(1);
                if (code == 'r') {
                    currentFormatting = new TextFormatting[]{};
                    continue;
                }
                TextFormatting format = TextFormatting.func_211165_a((char)code);
                if (format == null) continue;
                if (code >= 'k' && code <= 'o') {
                    ArrayList<TextFormatting> list = new ArrayList<TextFormatting>(Arrays.asList(currentFormatting));
                    list.add(format);
                    currentFormatting = list.toArray(new TextFormatting[0]);
                    continue;
                }
                currentFormatting = new TextFormatting[]{format};
                continue;
            }
            if (translatable) {
                Pattern pattern = Pattern.compile("\\{(.+?)\\}");
                Matcher matcher = pattern.matcher(part);
                StringTextComponent tempText = new StringTextComponent("");
                int lastIndex = 0;
                while (matcher.find()) {
                    if (matcher.start() > lastIndex) {
                        tempText.func_230529_a_((ITextComponent)new StringTextComponent(part.substring(lastIndex, matcher.start())).func_240701_a_(currentFormatting));
                    }
                    String key = matcher.group(1);
                    tempText.func_230529_a_((ITextComponent)new TranslationTextComponent(key).func_240701_a_(currentFormatting));
                    lastIndex = matcher.end();
                }
                if (lastIndex < part.length()) {
                    tempText.func_230529_a_((ITextComponent)new StringTextComponent(part.substring(lastIndex)).func_240701_a_(currentFormatting));
                }
                result.func_230529_a_((ITextComponent)tempText);
                continue;
            }
            result.func_230529_a_((ITextComponent)new StringTextComponent(part).func_240701_a_(currentFormatting));
        }
        return result;
    }

    public static String[] split(String text) {
        Matcher matcher = Pattern.compile("(?i)\u00a7[0-9a-fk-or]|[^\u00a7]+").matcher(text);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group());
        }
        return parts.toArray(new String[0]);
    }
}

