/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.tile;

import com.mojang.datafixers.types.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;

public class BlockEntityTypeBuilder<T extends TileEntity> {
    private final Factory<? extends T> factory;
    private final List<Block> blocks;

    public BlockEntityTypeBuilder(Factory<? extends T> factory, List<Block> blocks) {
        this.factory = factory;
        this.blocks = blocks;
    }

    public static <T extends TileEntity> BlockEntityTypeBuilder<T> create(Factory<? extends T> factory, Block ... blocks) {
        ArrayList<Block> blocksList = new ArrayList<Block>(blocks.length);
        Collections.addAll(blocksList, blocks);
        return new BlockEntityTypeBuilder<T>(factory, blocksList);
    }

    public BlockEntityTypeBuilder<T> addBlock(Block block) {
        this.blocks.add(block);
        return this;
    }

    public BlockEntityTypeBuilder<T> addBlocks(Block ... blocks) {
        Collections.addAll(this.blocks, blocks);
        return this;
    }

    public TileEntityType<T> build() {
        return this.build(null);
    }

    public TileEntityType<T> build(Type<?> type) {
        return TileEntityType.Builder.func_223042_a(this.factory::create, (Block[])this.blocks.toArray(new Block[0])).func_206865_a(type);
    }

    @FunctionalInterface
    public static interface Factory<T extends TileEntity> {
        public T create(TileCreateEvent var1);

        @Deprecated
        default public T create() {
            return this.create(new TileCreateEvent(null));
        }
    }
}

