/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.BlockEntityTypeUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class BlockEntityDataUtil {
    public static CompoundNBT getBlockEntityNbt(ItemStack stack) {
        if (!BlockEntityDataUtil.hasBlockEntityNbt(stack)) {
            return NbtUtil.create();
        }
        return stack.func_179543_a("BlockEntityTag");
    }

    public static void setBlockEntityNbt(ItemStack stack, CompoundNBT nbt) {
        stack.func_77983_a("BlockEntityTag", (INBT)nbt);
    }

    public static boolean hasBlockEntityNbt(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        return NbtUtil.has(stack.func_77978_p(), "BlockEntityTag");
    }

    public static void readCompatBlockEntityNbtFromStack(ItemStack stack, CompatBlockEntity blockEntity) {
        CompoundNBT nbt = BlockEntityDataUtil.getBlockEntityNbt(stack);
        blockEntity.readNbt(new ReadNbtArgs(nbt));
    }

    public static void writeCompatBlockEntityNbtToStack(ItemStack stack, CompatBlockEntity blockEntity) {
        CompoundNBT nbt = BlockEntityDataUtil.getBlockEntityNbt(stack);
        blockEntity.writeNbt(new WriteNbtArgs(nbt));
        NbtUtil.set(nbt, "id", BlockEntityTypeUtil.toID(blockEntity.func_200662_C()).toString());
        BlockEntityDataUtil.setBlockEntityNbt(stack, nbt);
    }

    public static void removeBlockEntityNbt(ItemStack stack) {
        stack.func_196083_e("BlockEntityTag");
    }
}

