/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.core.command.CommandResult;

public class CommandManagerUtil {
    public static Commands getCommandManager(MinecraftServer server) {
        return server.func_195571_aL();
    }

    public static CommandResult execute(MinecraftServer server, String command) {
        CommandDispatcher dispatcher = CommandManagerUtil.getCommandManager(server).func_197054_a();
        CommandSource source = server.func_195573_aM();
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        CommandResult cr = new CommandResult();
        cr.setSuccess(false);
        cr.setSource(source);
        try {
            int result = dispatcher.execute(command, (Object)source);
            cr.setResult(result);
            cr.setSuccess(true);
        }
        catch (CommandSyntaxException e) {
            cr.setMessage(e.getMessage());
            cr.setErrorType(CommandResult.ErrorType.COMMAND_SYNTAX_ERROR);
        }
        catch (RuntimeException e) {
            cr.setMessage(e.getMessage());
            cr.setErrorType(CommandResult.ErrorType.RUNTIME_ERROR);
        }
        return cr;
    }

    public static CommandResult execute(CommandSource source, String command) {
        CommandDispatcher dispatcher = source.func_197028_i().func_195571_aL().func_197054_a();
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        CommandResult cr = new CommandResult();
        cr.setSuccess(false);
        cr.setSource(source);
        try {
            int result = dispatcher.execute(command, (Object)source);
            cr.setResult(result);
            cr.setSuccess(true);
        }
        catch (CommandSyntaxException e) {
            cr.setMessage(e.getMessage());
            cr.setErrorType(CommandResult.ErrorType.COMMAND_SYNTAX_ERROR);
        }
        catch (RuntimeException e) {
            cr.setMessage(e.getMessage());
            cr.setErrorType(CommandResult.ErrorType.RUNTIME_ERROR);
        }
        return cr;
    }

    public static CommandResult execute(Player player, String command) {
        return CommandManagerUtil.execute(CommandManagerUtil.getCommandSource(player), command);
    }

    public static CommandSource getCommandSource(MinecraftServer server) {
        return server.func_195573_aM();
    }

    public static CommandSource getCommandSource(Player player) {
        return player.getEntity().func_195051_bN();
    }

    public static CommandSource withLevel(CommandSource source, int level) {
        return source.func_197033_a(level);
    }
}

