/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Optional;
import net.minecraft.util.ActionResultType;
import net.pitan76.mcpitanlib.api.event.result.EventResult;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;

public class CompatActionResult {
    public static final CompatActionResult SUCCESS = new CompatActionResult(ActionResultType.SUCCESS, EventResult.success());
    public static final CompatActionResult PASS = new CompatActionResult(ActionResultType.PASS, EventResult.pass());
    public static final CompatActionResult FAIL = new CompatActionResult(ActionResultType.FAIL, EventResult.fail());
    public static final CompatActionResult CONSUME = new CompatActionResult(ActionResultType.CONSUME, EventResult.success());
    public static final CompatActionResult PASS_TO_DEFAULT_BLOCK_ACTION = new CompatActionResult(ActionResultType.PASS, EventResult.pass());
    public static final CompatActionResult SUCCESS_SERVER = new CompatActionResult(ActionResultType.SUCCESS, EventResult.success());
    public static final CompatActionResult STOP = new CompatActionResult(ActionResultType.FAIL, EventResult.stop());
    private final ActionResultType actionResult;
    private final EventResult eventResult;

    protected CompatActionResult(ActionResultType actionResult, EventResult eventResult) {
        this.actionResult = actionResult;
        this.eventResult = eventResult;
    }

    public ActionResultType toActionResult() {
        return this.actionResult;
    }

    public EventResult toEventResult() {
        return this.eventResult;
    }

    public Optional<ItemStack> getNewMidohraHandStack() {
        return this.getNewHandStack().map(ItemStack::of);
    }

    public Optional<net.minecraft.item.ItemStack> getNewHandStack() {
        return Optional.empty();
    }

    public static CompatActionResult of(ActionResultType result) {
        if (result == ActionResultType.SUCCESS) {
            return SUCCESS;
        }
        if (result == ActionResultType.PASS) {
            return PASS;
        }
        if (result == ActionResultType.FAIL) {
            return FAIL;
        }
        if (result == ActionResultType.CONSUME) {
            return CONSUME;
        }
        return PASS;
    }

    public static CompatActionResult of(EventResult result) {
        if (result == EventResult.success()) {
            return SUCCESS;
        }
        if (result == EventResult.pass()) {
            return PASS;
        }
        if (result == EventResult.fail()) {
            return FAIL;
        }
        if (result == EventResult.stop()) {
            return STOP;
        }
        return PASS;
    }

    @Deprecated
    public static CompatActionResult create(ActionResultType result, EventResult eventResult) {
        return new CompatActionResult(result, eventResult);
    }

    @Deprecated
    public static CompatActionResult create(ActionResultType result) {
        return CompatActionResult.of(result);
    }

    @Deprecated
    public static CompatActionResult create2(ActionResultType result) {
        return CompatActionResult.create(result, EventResult.stop());
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof CompatActionResult)) {
            return false;
        }
        if (this.actionResult.equals((Object)((CompatActionResult)obj).actionResult)) {
            return this.eventResult.equals(((CompatActionResult)obj).eventResult);
        }
        return false;
    }

    public String getName() {
        if (this == SUCCESS) {
            return "SUCCESS";
        }
        if (this == PASS) {
            return "PASS";
        }
        if (this == FAIL) {
            return "FAIL";
        }
        if (this == CONSUME) {
            return "CONSUME";
        }
        if (this == PASS_TO_DEFAULT_BLOCK_ACTION) {
            return "PASS_TO_DEFAULT_BLOCK_ACTION";
        }
        if (this == SUCCESS_SERVER) {
            return "SUCCESS_SERVER";
        }
        if (this == STOP) {
            return "STOP";
        }
        return "UNKNOWN";
    }
}

