/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.enchantment.CompatEnchantment;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import org.jetbrains.annotations.Nullable;

public class EnchantmentUtil {
    public static CompatEnchantment getEnchantment(ResourceLocation identifier) {
        return new CompatEnchantment((Enchantment)Registry.field_212628_q.func_82594_a(identifier));
    }

    public static ResourceLocation getId(CompatEnchantment enchantment) {
        return enchantment.getId();
    }

    public static int getLevel(CompatEnchantment enchantment, ItemStack stack, @Nullable World world) {
        return enchantment.getLevel(stack, world);
    }

    public static CompatEnchantment getEnchantment(CompatIdentifier identifier) {
        return EnchantmentUtil.getEnchantment(identifier.toMinecraft());
    }

    public static CompatIdentifier getCompatId(CompatEnchantment enchantment) {
        return CompatIdentifier.fromMinecraft(enchantment.getId());
    }

    public static List<CompatEnchantment> getEnchantments(ItemStack stack) {
        ArrayList<CompatEnchantment> enchantments = new ArrayList<CompatEnchantment>();
        EnchantmentHelper.func_82781_a((ItemStack)stack).forEach((key, value) -> enchantments.add(new CompatEnchantment((Enchantment)key)));
        return enchantments;
    }

    public static boolean hasEnchantment(ItemStack stack) {
        return stack.func_77948_v();
    }

    public static Map<CompatEnchantment, Integer> getEnchantment(ItemStack stack, @Nullable World world) {
        HashMap<CompatEnchantment, Integer> enchantments = new HashMap<CompatEnchantment, Integer>();
        List<CompatEnchantment> enchantmentList = EnchantmentUtil.getEnchantments(stack);
        enchantmentList.forEach(enchantment -> enchantments.put((CompatEnchantment)enchantment, EnchantmentUtil.getLevel(enchantment, stack, world)));
        return enchantments;
    }

    public static void setEnchantment(ItemStack stack, Map<CompatEnchantment, Integer> enchantments, @Nullable World world) {
        HashMap enchantmentMap = new HashMap();
        enchantments.forEach((key, value) -> enchantmentMap.put(key.getEnchantment(world), value));
        EnchantmentHelper.func_82782_a(enchantmentMap, (ItemStack)stack);
    }

    public static void removeEnchantment(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt.func_74764_b("enchantments")) {
            stack.func_196083_e("enchantments");
        }
        if (nbt.func_74764_b("stored_enchantments")) {
            stack.func_196083_e("stored_enchantments");
        }
        if (nbt.func_74764_b("Enchantments")) {
            stack.func_196083_e("Enchantments");
        }
        if (nbt.func_74764_b("StoredEnchantments")) {
            stack.func_196083_e("StoredEnchantments");
        }
    }
}

