/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.util.DamageSourceUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;

public class EntityUtil {
    public static World getWorld(Entity entity) {
        return entity.func_130014_f_();
    }

    public static boolean damage(Entity target, DamageSource damageSource, float amount) {
        return target.func_70097_a(damageSource, amount);
    }

    public static boolean damageWithThrownProjectile(Entity target, float damageAmount, Entity projectile, Entity attacker) {
        return target.func_70097_a(DamageSourceUtil.thrownProjectile(projectile, attacker), damageAmount);
    }

    public static boolean damageWithMobProjectile(Entity target, float damageAmount, Entity projectile, LivingEntity attacker) {
        return target.func_70097_a(DamageSourceUtil.mobProjectile(projectile, attacker), damageAmount);
    }

    public static boolean damageWithMobAttack(Entity target, float damageAmount, Entity source, LivingEntity attacker) {
        return target.func_70097_a(DamageSourceUtil.mobAttack(attacker, source), damageAmount);
    }

    public static boolean damageWithPlayerAttack(Entity target, float damageAmount, Entity source, Player attacker) {
        return target.func_70097_a(DamageSourceUtil.playerAttack(attacker, source), damageAmount);
    }

    public static void discard(Entity entity) {
        entity.func_70106_y();
    }

    public static void kill(Entity entity) {
        entity.func_174812_G();
    }

    public static void setVelocity(Entity entity, double x, double y, double z) {
        entity.func_213293_j(x, y, z);
    }

    public static Vector3d getVelocity(Entity entity) {
        return entity.func_213322_ci();
    }

    public static void setNoGravity(Entity entity, boolean noGravity) {
        entity.func_189654_d(noGravity);
    }

    public static boolean hasNoGravity(Entity entity) {
        return entity.func_189652_ae();
    }

    public static void setInvulnerable(Entity entity, boolean invulnerable) {
        entity.func_184224_h(invulnerable);
    }

    public static boolean isInvulnerable(Entity entity) {
        return entity.func_190530_aW();
    }

    public static void setSilent(Entity entity, boolean silent) {
        entity.func_174810_b(silent);
    }

    public static boolean isSilent(Entity entity) {
        return entity.func_174814_R();
    }

    public static void setGlowing(Entity entity, boolean glowing) {
        entity.func_184195_f(glowing);
    }

    public static boolean isGlowing(Entity entity) {
        return entity.func_225510_bt_();
    }

    public static void setFire(Entity entity, int seconds) {
        entity.func_70015_d(seconds);
    }

    public static void extinguish(Entity entity) {
        entity.func_70066_B();
    }

    public static boolean isOnFire(Entity entity) {
        return entity.func_70027_ad();
    }

    public static void setInvisible(Entity entity, boolean invisible) {
        entity.func_82142_c(invisible);
    }

    public static boolean isInvisible(Entity entity) {
        return entity.func_82150_aj();
    }

    public static void setSneaking(Entity entity, boolean sneaking) {
        entity.func_226284_e_(sneaking);
    }

    public static boolean isSneaking(Entity entity) {
        return entity.func_225608_bj_();
    }

    public static void setSprinting(Entity entity, boolean sprinting) {
        entity.func_70031_b(sprinting);
    }

    public static boolean isSprinting(Entity entity) {
        return entity.func_70051_ag();
    }

    public static void setSwimming(Entity entity, boolean swimming) {
        entity.func_204711_a(swimming);
    }

    public static boolean isSwimming(Entity entity) {
        return entity.func_203007_ba();
    }

    public static void detach(Entity entity) {
        entity.func_213319_R();
    }

    public static void attach(Entity entity, Entity vehicle) {
        entity.func_184205_a(vehicle, true);
    }

    public static void detachFromVehicle(Entity entity) {
        entity.func_184210_p();
    }

    public static boolean isRiding(Entity entity) {
        return entity.func_184218_aH();
    }

    public static Entity getVehicle(Entity entity) {
        return entity.func_184187_bx();
    }

    public static void setVehicle(Entity entity, Entity vehicle) {
        entity.func_184205_a(vehicle, true);
    }

    public static void applyRotation(Entity entity, Rotation rotation) {
        entity.func_184229_a(rotation);
    }

    public static void setVelocity(Entity entity, Vector3d velocity) {
        entity.func_213317_d(velocity);
    }

    public static void setFallDistance(Entity entity, double fallDistance) {
        entity.field_70143_R = (float)fallDistance;
    }

    public static double getFallDistance(Entity entity) {
        return entity.field_70143_R;
    }

    public static void setVelocityModified(Entity entity, boolean velocityModified) {
        entity.field_70133_I = velocityModified;
    }

    public static boolean isVelocityModified(Entity entity) {
        return entity.field_70133_I;
    }

    public static float getYaw(Entity entity) {
        return entity.field_70177_z;
    }

    public static float getPitch(Entity entity) {
        return entity.field_70125_A;
    }

    public static void setYaw(Entity entity, float yaw) {
        entity.field_70177_z = yaw;
    }

    public static void setPitch(Entity entity, float pitch) {
        entity.field_70125_A = pitch;
    }

    public static float getSpeed(Entity entity) {
        return entity.field_70140_Q;
    }

    public static void setSpeed(Entity entity, float speed) {
        entity.field_70140_Q = speed;
    }

    public static boolean isOnGround(Entity entity) {
        return entity.func_233570_aj_();
    }

    public static void setOnGround(Entity entity, boolean onGround) {
        entity.func_230245_c_(onGround);
    }

    public static boolean isAlive(Entity entity) {
        return entity.func_70089_S();
    }

    public static UUID getUuid(Entity entity) {
        return entity.func_110124_au();
    }

    public static String getUuidString(Entity entity) {
        return entity.func_189512_bd();
    }

    public static void setUuid(Entity entity, UUID uuid) {
        entity.func_184221_a(uuid);
    }

    public static ITextComponent getName(Entity entity) {
        return entity.func_200200_C_();
    }

    public static ITextComponent getDisplayName(Entity entity) {
        return entity.func_145748_c_();
    }

    public static void setCustomName(Entity entity, ITextComponent customName) {
        entity.func_200203_b(customName);
    }

    public static ITextComponent getCustomName(Entity entity) {
        return entity.func_200201_e();
    }

    public static void setCustomNameVisible(Entity entity, boolean visible) {
        entity.func_174805_g(visible);
    }

    public static boolean isCustomNameVisible(Entity entity) {
        return entity.func_174833_aM();
    }

    public static boolean hasCustomName(Entity entity) {
        return entity.func_145818_k_();
    }

    public static String getNameAsString(Entity entity) {
        return entity.func_200200_C_().getString();
    }

    public static String getDisplayNameAsString(Entity entity) {
        if (entity.func_145748_c_() == null) {
            return null;
        }
        return entity.func_145748_c_().getString();
    }

    public static String getCustomNameAsString(Entity entity) {
        if (entity.func_200201_e() == null) {
            return null;
        }
        return entity.func_200201_e().getString();
    }

    public static void setCustomName(Entity entity, String customName) {
        entity.func_200203_b((ITextComponent)TextUtil.literal(customName));
    }

    public static Vector3d getRotationVector(Entity entity) {
        return entity.func_70040_Z();
    }
}

