/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;

public class FluidUtil {
    public static ResourceLocation toID(Fluid fluid) {
        return Registry.field_212619_h.func_177774_c((Object)fluid);
    }

    public static Fluid fromId(ResourceLocation identifier) {
        return (Fluid)Registry.field_212619_h.func_82594_a(identifier);
    }

    public static Fluid fromId(CompatIdentifier identifier) {
        return FluidUtil.fromId(identifier.toMinecraft());
    }

    public static int getRawId(Fluid fluid) {
        return Registry.field_212619_h.func_148757_b((Object)fluid);
    }

    public static Fluid fromIndex(int index) {
        return (Fluid)Registry.field_212619_h.func_148745_a(index);
    }

    public static boolean isExist(CompatIdentifier id) {
        return Registry.field_212619_h.func_212607_c(id.toMinecraft());
    }

    public static CompatIdentifier toCompatId(Fluid fluid) {
        return CompatIdentifier.fromMinecraft(FluidUtil.toID(fluid));
    }

    public static Fluid fromCompatId(CompatIdentifier id) {
        return FluidUtil.fromId(id.toMinecraft());
    }

    public static FlowingFluid water() {
        return Fluids.field_204546_a;
    }

    public static FlowingFluid lava() {
        return Fluids.field_204547_b;
    }

    public static Fluid empty() {
        return Fluids.field_204541_a;
    }

    public static FlowingFluid flowingWater() {
        return Fluids.field_207212_b;
    }

    public static FlowingFluid flowingLava() {
        return Fluids.field_207213_d;
    }

    public static boolean isStill(Fluid fluid) {
        return fluid == FluidUtil.water() || fluid == FluidUtil.lava();
    }

    public static boolean isStill(FluidState state) {
        return state.func_206889_d();
    }

    public static FluidState getStill(FlowingFluid fluid, boolean falling) {
        return fluid.func_207204_a(falling);
    }

    public static FluidState getFlowing(FlowingFluid fluid, int level, boolean falling) {
        return fluid.func_207207_a(level, falling);
    }

    public static FluidState getStill(FlowingFluid fluid) {
        return FluidUtil.getStill(fluid, false);
    }

    public static FluidState getStillWater() {
        return FluidUtil.getStill(FluidUtil.water());
    }

    public static FluidState getStillLava() {
        return FluidUtil.getStill(FluidUtil.lava());
    }

    public static boolean isFlowing(Fluid fluid) {
        return fluid == FluidUtil.flowingWater() || fluid == FluidUtil.flowingLava();
    }

    public static int getTickRate(Fluid fluid, IWorldReader world) {
        return fluid.func_205569_a(world);
    }

    public static FluidState getDefaultState(Fluid fluid) {
        return fluid.func_207188_f();
    }

    public static Item getBucketItem(Fluid fluid) {
        return fluid.func_204524_b();
    }
}

