/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemUtil;

public class IngredientUtil {
    public static Ingredient fromTagByIdentifier(ResourceLocation id) {
        return Ingredient.func_199805_a((ITag)ItemTags.func_199903_a().func_241834_b(id));
    }

    public static Ingredient fromTagByString(String id) {
        return IngredientUtil.fromTagByIdentifier(new ResourceLocation(id));
    }

    public static Ingredient fromTagByIdentifier(CompatIdentifier id) {
        return IngredientUtil.fromTagByIdentifier(id.toMinecraft());
    }

    public static List<Item> getItems(Ingredient ingredient) {
        ArrayList<Item> items = new ArrayList<Item>();
        IntListIterator intListIterator = ingredient.func_194139_b().iterator();
        while (intListIterator.hasNext()) {
            int rawId = (Integer)intListIterator.next();
            try {
                items.add(ItemUtil.fromIndex(rawId));
            }
            catch (Exception exception) {}
        }
        return items;
    }

    public static IntList getMatchingStacksIds(Ingredient ingredient) {
        return ingredient.func_194139_b();
    }

    public static List<ItemStack> getMatchingStacksAsList(Ingredient ingredient) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item item : IngredientUtil.getItems(ingredient)) {
            stacks.add(new ItemStack((IItemProvider)item));
        }
        return stacks;
    }

    public static ItemStack[] getMatchingStacks(Ingredient ingredient) {
        return IngredientUtil.getMatchingStacksAsList(ingredient).toArray(new ItemStack[0]);
    }

    public static Ingredient empty() {
        return Ingredient.field_193370_a;
    }

    public static Ingredient ofItems(IItemProvider ... items) {
        return Ingredient.func_199804_a((IItemProvider[])items);
    }

    public static NonNullList<Ingredient> buildInput(Object[] input) {
        NonNullList list = NonNullList.func_191196_a();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            if (!(obj instanceof IItemProvider)) continue;
            list.add((Object)IngredientUtil.ofItems((IItemProvider)obj));
        }
        return list;
    }
}

