/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;

public class InventoryUtil {
    public static boolean insertItem(ItemStack insertStack, NonNullList<ItemStack> inventory) {
        return InventoryUtil.insertItem(insertStack, inventory, false);
    }

    public static boolean insertItem(ItemStack insertStack, NonNullList<ItemStack> inventory, boolean test) {
        boolean isInserted = false;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.func_190926_b()) {
                if (!test) {
                    inventory.set(i, (Object)insertStack);
                }
                isInserted = true;
                break;
            }
            if (!InventoryUtil.canMergeItems(stack, insertStack)) continue;
            int j = insertStack.func_190916_E();
            if (!test) {
                stack.func_190917_f(j);
            }
            isInserted = j > 0;
            break;
        }
        return isInserted;
    }

    public static boolean canMergeItems(ItemStack first, ItemStack second) {
        if (!first.func_77973_b().equals(second.func_77973_b())) {
            return false;
        }
        if (first.func_77952_i() != second.func_77952_i()) {
            return false;
        }
        if (first.func_190916_E() + second.func_190916_E() > first.func_77976_d()) {
            return false;
        }
        return ItemStackUtil.areNbtOrComponentEqual(first, second);
    }

    public static CompoundNBT writeNbt(NbtRWArgs args, CompoundNBT nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        return ItemStackHelper.func_191281_a((CompoundNBT)nbt, stacks, (boolean)setIfEmpty);
    }

    public static void readNbt(NbtRWArgs args, CompoundNBT nbt, NonNullList<ItemStack> stacks) {
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, stacks);
    }

    public static CompoundNBT writeNbt(NbtRWArgs args, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        return ItemStackHelper.func_191281_a((CompoundNBT)args.getNbt(), stacks, (boolean)setIfEmpty);
    }

    public static CompoundNBT writeNbt(NbtRWArgs args, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(args, stacks, true);
    }

    public static void readNbt(NbtRWArgs args, NonNullList<ItemStack> stacks) {
        ItemStackHelper.func_191283_b((CompoundNBT)args.getNbt(), stacks);
    }

    public static void readNbt(CompatRegistryLookup registryLookup, CompoundNBT nbt, NonNullList<ItemStack> stacks) {
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, stacks);
    }

    public static CompoundNBT writeNbt(CompatRegistryLookup registryLookup, CompoundNBT nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        return ItemStackHelper.func_191281_a((CompoundNBT)nbt, stacks, (boolean)setIfEmpty);
    }

    public static CompoundNBT writeNbt(CompatRegistryLookup registryLookup, CompoundNBT nbt, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(registryLookup, nbt, stacks, true);
    }

    @Deprecated
    public static CompoundNBT writeNbt(World world, CompoundNBT nbt, NonNullList<ItemStack> stacks) {
        return InventoryUtil.writeNbt(world, nbt, true, stacks);
    }

    @Deprecated
    public static CompoundNBT writeNbt(World world, CompoundNBT nbt, boolean setIfEmpty, NonNullList<ItemStack> stacks) {
        return ItemStackHelper.func_191281_a((CompoundNBT)nbt, stacks, (boolean)setIfEmpty);
    }

    @Deprecated
    public static void readNbt(World world, CompoundNBT nbt, NonNullList<ItemStack> stacks) {
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, stacks);
    }

    public static Inventory createSimpleInventory(int size) {
        return new Inventory(size);
    }

    public static void copyToInv(NonNullList<ItemStack> from, IInventory to) {
        for (int i = 0; i < from.size(); ++i) {
            to.func_70299_a(i, (ItemStack)from.get(i));
        }
    }

    public static void copyToList(IInventory from, NonNullList<ItemStack> to) {
        for (int i = 0; i < from.func_70302_i_(); ++i) {
            to.set(i, (Object)from.func_70301_a(i));
        }
    }

    public static int getSize(IInventory inventory) {
        return inventory.func_70302_i_();
    }

    public static ItemStack getStack(IInventory inventory, int slot) {
        return inventory.func_70301_a(slot);
    }

    public static void setStack(IInventory inventory, int slot, ItemStack stack) {
        inventory.func_70299_a(slot, stack);
    }

    public static boolean isEmpty(IInventory inventory) {
        return inventory.func_191420_l();
    }

    public static ItemStack removeStack(IInventory inventory, int slot) {
        return inventory.func_70304_b(slot);
    }

    public static ItemStack removeStack(IInventory inventory, int slot, int amount) {
        return inventory.func_70298_a(slot, amount);
    }

    public static void clear(IInventory inventory) {
        inventory.func_174888_l();
    }

    public static void markDirty(IInventory inventory) {
        inventory.func_70296_d();
    }
}

