/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;

public class ItemStackUtil {
    public static ItemStack copy(ItemStack stack) {
        return stack.func_77946_l();
    }

    public static ItemStack copyWithCount(ItemStack stack, int count) {
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(count);
        return copy;
    }

    public static boolean areItemsEqual(ItemStack left, ItemStack right) {
        return ItemStack.func_185132_d((ItemStack)left, (ItemStack)right);
    }

    @Deprecated
    public static boolean areNbtEqual(ItemStack left, ItemStack right) {
        return ItemStackUtil.areNbtOrComponentEqual(left, right);
    }

    public static boolean areNbtOrComponentEqual(ItemStack left, ItemStack right) {
        return ItemStack.func_77970_a((ItemStack)left, (ItemStack)right);
    }

    public static boolean hasNbtOrComponent(ItemStack stack) {
        return stack.func_77942_o();
    }

    public static ItemStack fromNbt(World world, CompoundNBT nbt) {
        return ItemStack.func_199557_a((CompoundNBT)nbt);
    }

    public static ItemStack fromNbt(NbtRWArgs args) {
        return ItemStack.func_199557_a((CompoundNBT)args.getNbt());
    }

    public static ItemStack getDefaultStack(Item item) {
        return item.func_190903_i();
    }

    public static int getMaxDamage(ItemStack stack) {
        return stack.func_77958_k();
    }

    public static int getMaxDamage(Item item) {
        return ItemStackUtil.getMaxDamage(ItemStackUtil.getDefaultStack(item));
    }

    public static int getDamage(ItemStack stack) {
        return stack.func_77952_i();
    }

    public static void setDamage(ItemStack stack, int damage) {
        stack.func_196085_b(damage);
    }

    public static int getCount(ItemStack stack) {
        return stack.func_190916_E();
    }

    public static void setCount(ItemStack stack, int count) {
        stack.func_190920_e(count);
    }

    public static void decrementCount(ItemStack stack, int count) {
        stack.func_190918_g(count);
    }

    public static void incrementCount(ItemStack stack, int count) {
        stack.func_190917_f(count);
    }

    public static void damage(ItemStack stack, int amount, ServerPlayerEntity entity, Runnable breakCallback) {
        stack.func_222118_a(amount, (LivingEntity)entity, player -> breakCallback.run());
    }

    public static void damage(ItemStack stack, int amount, LivingEntity entity, EquipmentSlotType slot) {
        if (entity instanceof ServerPlayerEntity) {
            ItemStackUtil.damage(stack, amount, (ServerPlayerEntity)entity, () -> {});
        }
    }

    public static void damage(ItemStack stack, int amount, ServerPlayerEntity entity) {
        stack.func_222118_a(amount, (LivingEntity)entity, entity2 -> entity2.func_213361_c(EquipmentSlotType.MAINHAND));
    }

    public static void damage(ItemStack stack, int amount, Player entity) {
        Optional<ServerPlayerEntity> player = entity.getServerPlayer();
        if (!player.isPresent()) {
            return;
        }
        ItemStackUtil.damage(stack, amount, player.get());
    }

    public static ItemStack empty() {
        return ItemStack.field_190927_a;
    }

    public static ItemStack create(Item item) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack((IItemProvider)item);
    }

    public static ItemStack create(Item item, int count) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack((IItemProvider)item, count);
    }

    public static ItemStack create(IItemProvider item) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack(item);
    }

    public static ItemStack create(IItemProvider item, int count) {
        if (item == null) {
            return ItemStackUtil.empty();
        }
        return new ItemStack(item, count);
    }

    public static boolean isEmpty(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        return stack.func_190926_b();
    }

    public static boolean isEnchantable(ItemStack stack) {
        return stack.func_77956_u();
    }

    public static boolean isDamageable(ItemStack stack) {
        return stack.func_77984_f();
    }

    public static boolean isBreak(ItemStack stack) {
        if (ItemStackUtil.isDamageable(stack)) {
            return ItemStackUtil.getDamage(stack) >= ItemStackUtil.getMaxDamage(stack);
        }
        return false;
    }

    public static ItemWrapper getItemWrapper(ItemStack stack) {
        return ItemWrapper.of(stack.func_77973_b());
    }

    public static int getMaxCount(ItemStack stack) {
        return stack.func_77976_d();
    }

    public static Item getItem(ItemStack stack) {
        return stack.func_77973_b();
    }
}

