/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.api.util.math.Vec3dUtil;
import net.pitan76.mcpitanlib.api.util.math.Vec3iUtil;

public class NbtUtil {
    public static CompoundNBT create() {
        return new CompoundNBT();
    }

    public static void put(CompoundNBT nbt, String key, CompoundNBT value) {
        nbt.func_218657_a(key, (INBT)value);
    }

    public static void put(CompoundNBT nbt, String key, INBT value) {
        nbt.func_218657_a(key, value);
    }

    public static CompoundNBT get(CompoundNBT nbt, String key) {
        return nbt.func_74775_l(key);
    }

    public static void remove(CompoundNBT nbt, String key) {
        nbt.func_82580_o(key);
    }

    public static boolean has(CompoundNBT nbt, String key) {
        return nbt.func_74764_b(key);
    }

    public static <T> T get(CompoundNBT nbt, String key, Class<T> clazz) {
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(nbt.func_74762_e(key));
        }
        if (clazz == String.class) {
            return (T)nbt.func_74779_i(key);
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(nbt.func_74767_n(key));
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(nbt.func_74760_g(key));
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(nbt.func_74769_h(key));
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(nbt.func_74763_f(key));
        }
        if (clazz == CompoundNBT.class) {
            return (T)nbt.func_74775_l(key);
        }
        if (clazz == ListNBT.class) {
            return (T)nbt.func_74781_a(key);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(nbt.func_74771_c(key));
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(nbt.func_74765_d(key));
        }
        if (clazz == UUID.class) {
            return (T)nbt.func_186857_a(key);
        }
        return null;
    }

    public static <T> void set(CompoundNBT nbt, String key, T value) {
        if (value instanceof Integer) {
            nbt.func_74768_a(key, ((Integer)value).intValue());
            return;
        }
        if (value instanceof String) {
            nbt.func_74778_a(key, (String)value);
            return;
        }
        if (value instanceof Boolean) {
            nbt.func_74757_a(key, ((Boolean)value).booleanValue());
            return;
        }
        if (value instanceof Float) {
            nbt.func_74776_a(key, ((Float)value).floatValue());
            return;
        }
        if (value instanceof Double) {
            nbt.func_74780_a(key, ((Double)value).doubleValue());
            return;
        }
        if (value instanceof Long) {
            nbt.func_74772_a(key, ((Long)value).longValue());
            return;
        }
        if (value instanceof CompoundNBT) {
            nbt.func_218657_a(key, (INBT)((CompoundNBT)value));
            return;
        }
        if (value instanceof ListNBT) {
            nbt.func_218657_a(key, (INBT)((ListNBT)value));
            return;
        }
        if (value instanceof Byte) {
            nbt.func_74774_a(key, ((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            nbt.func_74777_a(key, ((Short)value).shortValue());
            return;
        }
        if (value instanceof UUID) {
            nbt.func_186854_a(key, (UUID)value);
            return;
        }
    }

    public static Set<String> getKeys(CompoundNBT nbt) {
        return nbt.func_150296_c();
    }

    public static ListNBT getList(CompoundNBT nbt, String key) {
        return (ListNBT)nbt.func_74781_a(key);
    }

    public static ListNBT getList(CompoundNBT nbt, String key, int type) {
        return nbt.func_150295_c(key, type);
    }

    public static ListNBT getNbtCompoundList(CompoundNBT nbt, String key) {
        return nbt.func_150295_c(key, 10);
    }

    public static CompoundNBT copy(CompoundNBT nbt) {
        return nbt.func_74737_b();
    }

    public static void putInt(CompoundNBT nbt, String key, int value) {
        NbtUtil.set(nbt, key, value);
    }

    public static int getInt(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Integer.class);
        }
        return 0;
    }

    public static void putString(CompoundNBT nbt, String key, String value) {
        NbtUtil.set(nbt, key, value);
    }

    public static String getString(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, String.class);
        }
        return "";
    }

    public static void putBoolean(CompoundNBT nbt, String key, boolean value) {
        NbtUtil.set(nbt, key, value);
    }

    public static boolean getBoolean(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Boolean.class);
        }
        return false;
    }

    public static void putFloat(CompoundNBT nbt, String key, float value) {
        NbtUtil.set(nbt, key, Float.valueOf(value));
    }

    public static float getFloat(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Float.class).floatValue();
        }
        return 0.0f;
    }

    public static void putDouble(CompoundNBT nbt, String key, double value) {
        NbtUtil.set(nbt, key, value);
    }

    public static double getDouble(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Double.class);
        }
        return 0.0;
    }

    public static void putLong(CompoundNBT nbt, String key, long value) {
        NbtUtil.set(nbt, key, value);
    }

    public static long getLong(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Long.class);
        }
        return 0L;
    }

    public static void putByte(CompoundNBT nbt, String key, byte value) {
        NbtUtil.set(nbt, key, value);
    }

    public static byte getByte(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Byte.class);
        }
        return 0;
    }

    public static void putShort(CompoundNBT nbt, String key, short value) {
        NbtUtil.set(nbt, key, value);
    }

    public static short getShort(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Short.class);
        }
        return 0;
    }

    public static void putUuid(CompoundNBT nbt, String key, UUID value) {
        NbtUtil.set(nbt, key, value);
    }

    public static UUID getUuid(CompoundNBT nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, UUID.class);
        }
        return null;
    }

    public static void setBlockPos(CompoundNBT nbt, String key, BlockPos pos) {
        CompoundNBT posNbt = NbtUtil.create();
        NbtUtil.putInt(posNbt, "x", pos.func_177958_n());
        NbtUtil.putInt(posNbt, "y", pos.func_177956_o());
        NbtUtil.putInt(posNbt, "z", pos.func_177952_p());
        NbtUtil.put(nbt, key, posNbt);
    }

    public static BlockPos getBlockPos(CompoundNBT nbt, String key) {
        CompoundNBT posNbt = NbtUtil.get(nbt, key);
        return PosUtil.flooredBlockPos(NbtUtil.getInt(posNbt, "x"), NbtUtil.getInt(posNbt, "y"), NbtUtil.getInt(posNbt, "z"));
    }

    public static void putVec3i(CompoundNBT nbt, String key, Vector3i vec3i) {
        CompoundNBT vec3iNbt = NbtUtil.create();
        NbtUtil.putInt(vec3iNbt, "x", vec3i.func_177958_n());
        NbtUtil.putInt(vec3iNbt, "y", vec3i.func_177956_o());
        NbtUtil.putInt(vec3iNbt, "z", vec3i.func_177952_p());
        NbtUtil.put(nbt, key, vec3iNbt);
    }

    public static Vector3i getVec3i(CompoundNBT nbt, String key) {
        CompoundNBT vec3iNbt = NbtUtil.get(nbt, key);
        return Vec3iUtil.create(NbtUtil.getInt(vec3iNbt, "x"), NbtUtil.getInt(vec3iNbt, "y"), NbtUtil.getInt(vec3iNbt, "z"));
    }

    public static void putVec3d(CompoundNBT nbt, String key, Vector3d vec3d) {
        CompoundNBT vec3dNbt = NbtUtil.create();
        NbtUtil.putDouble(vec3dNbt, "x", vec3d.func_82615_a());
        NbtUtil.putDouble(vec3dNbt, "y", vec3d.func_82617_b());
        NbtUtil.putDouble(vec3dNbt, "z", vec3d.func_82616_c());
        NbtUtil.put(nbt, key, vec3dNbt);
    }

    public static Vector3d getVec3d(CompoundNBT nbt, String key) {
        CompoundNBT vec3dNbt = NbtUtil.get(nbt, key);
        return Vec3dUtil.create(NbtUtil.getDouble(vec3dNbt, "x"), NbtUtil.getDouble(vec3dNbt, "y"), NbtUtil.getDouble(vec3dNbt, "z"));
    }

    public static void putItemStack(CompoundNBT nbt, String key, ItemStack stack, CompatRegistryLookup registryLookup) {
        CompoundNBT stackNbt = NbtUtil.create();
        stack.func_77955_b(stackNbt);
        NbtUtil.put(nbt, key, stackNbt);
    }

    public static Optional<ItemStack> getItemStack(CompoundNBT nbt, String key, CompatRegistryLookup registryLookup) {
        CompoundNBT stackNbt = NbtUtil.get(nbt, key);
        return Optional.ofNullable(ItemStack.func_199557_a((CompoundNBT)stackNbt));
    }

    public static void putSimpleItemStack(CompoundNBT nbt, String key, ItemStack stack) {
        CompoundNBT stackNbt = NbtUtil.create();
        NbtUtil.putString(stackNbt, "id", ItemUtil.toID(stack.func_77973_b()).toString());
        NbtUtil.putByte(stackNbt, "Count", (byte)ItemStackUtil.getCount(stack));
        CompoundNBT tagNbt = NbtUtil.create();
        CompoundNBT componentsNbt = NbtUtil.create();
        NbtUtil.put(componentsNbt, "minecraft:custom_data", CustomDataUtil.getOrCreateNbt(stack));
        NbtUtil.put(tagNbt, "components", componentsNbt);
        NbtUtil.put(stackNbt, "tag", tagNbt);
        NbtUtil.put(nbt, key, stackNbt);
    }

    public static Optional<ItemStack> getSimpleItemStack(CompoundNBT nbt, String key) {
        CompoundNBT componentsNbt;
        CompoundNBT tagNbt;
        if (!NbtUtil.has(nbt, key)) {
            return Optional.empty();
        }
        CompoundNBT stackNbt = NbtUtil.get(nbt, key);
        if (!NbtUtil.has(stackNbt, "id") || !NbtUtil.has(stackNbt, "Count")) {
            return Optional.empty();
        }
        Item item = ItemUtil.fromId(CompatIdentifier.of(NbtUtil.getString(stackNbt, "id")));
        byte count = NbtUtil.getByte(stackNbt, "Count");
        ItemStack stack = ItemStackUtil.create(item, (int)count);
        if (NbtUtil.has(stackNbt, "tag") && NbtUtil.has(tagNbt = NbtUtil.get(stackNbt, "tag"), "components") && NbtUtil.has(componentsNbt = NbtUtil.get(tagNbt, "components"), "minecraft:custom_data")) {
            CustomDataUtil.setNbt(stack, NbtUtil.get(componentsNbt, "minecraft:custom_data"));
        }
        return Optional.of(stack);
    }

    public static ListNBT createNbtList() {
        return new ListNBT();
    }

    public static int getIntOrDefault(CompoundNBT nbt, String key, int defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getInt(nbt, key);
        }
        return defaultValue;
    }

    public static String getStringOrDefault(CompoundNBT nbt, String key, String defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getString(nbt, key);
        }
        return defaultValue;
    }

    public static boolean getBooleanOrDefault(CompoundNBT nbt, String key, boolean defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getBoolean(nbt, key);
        }
        return defaultValue;
    }

    public static float getFloatOrDefault(CompoundNBT nbt, String key, float defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getFloat(nbt, key);
        }
        return defaultValue;
    }

    public static double getDoubleOrDefault(CompoundNBT nbt, String key, double defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getDouble(nbt, key);
        }
        return defaultValue;
    }

    public static long getLongOrDefault(CompoundNBT nbt, String key, long defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getLong(nbt, key);
        }
        return defaultValue;
    }

    public static byte getByteOrDefault(CompoundNBT nbt, String key, byte defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getByte(nbt, key);
        }
        return defaultValue;
    }

    public static short getShortOrDefault(CompoundNBT nbt, String key, short defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getShort(nbt, key);
        }
        return defaultValue;
    }

    public static UUID getUuidOrDefault(CompoundNBT nbt, String key, UUID defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getUuid(nbt, key);
        }
        return defaultValue;
    }

    public static INBT getElement(CompoundNBT nbt, String key) {
        return nbt.func_74781_a(key);
    }

    public static void putElement(CompoundNBT nbt, String key, INBT element) {
        nbt.func_218657_a(key, element);
    }

    public static void setBlockPosDirect(CompoundNBT nbt, BlockPos pos) {
        NbtUtil.putInt(nbt, "x", pos.func_177958_n());
        NbtUtil.putInt(nbt, "y", pos.func_177956_o());
        NbtUtil.putInt(nbt, "z", pos.func_177952_p());
    }

    public static BlockPos getBlockPosDirect(CompoundNBT nbt) {
        return PosUtil.flooredBlockPos(NbtUtil.getInt(nbt, "x"), NbtUtil.getInt(nbt, "y"), NbtUtil.getInt(nbt, "z"));
    }

    public static void setVec3iDirect(CompoundNBT nbt, Vector3i vec3i) {
        NbtUtil.putInt(nbt, "x", vec3i.func_177958_n());
        NbtUtil.putInt(nbt, "y", vec3i.func_177956_o());
        NbtUtil.putInt(nbt, "z", vec3i.func_177952_p());
    }

    public static Vector3i getVec3iDirect(CompoundNBT nbt) {
        return Vec3iUtil.create(NbtUtil.getInt(nbt, "x"), NbtUtil.getInt(nbt, "y"), NbtUtil.getInt(nbt, "z"));
    }

    public static void setVec3dDirect(CompoundNBT nbt, Vector3d vec3d) {
        NbtUtil.putDouble(nbt, "x", vec3d.func_82615_a());
        NbtUtil.putDouble(nbt, "y", vec3d.func_82617_b());
        NbtUtil.putDouble(nbt, "z", vec3d.func_82616_c());
    }

    public static Vector3d getVec3dDirect(CompoundNBT nbt) {
        return Vec3dUtil.create(NbtUtil.getDouble(nbt, "x"), NbtUtil.getDouble(nbt, "y"), NbtUtil.getDouble(nbt, "z"));
    }

    public static void setVec3iDirect(CompoundNBT nbt, int x, int y, int z) {
        NbtUtil.putInt(nbt, "x", x);
        NbtUtil.putInt(nbt, "y", y);
        NbtUtil.putInt(nbt, "z", z);
    }

    public static void setVec3dDirect(CompoundNBT nbt, double x, double y, double z) {
        NbtUtil.putDouble(nbt, "x", x);
        NbtUtil.putDouble(nbt, "y", y);
        NbtUtil.putDouble(nbt, "z", z);
    }

    public static String asString(INBT nbt) {
        return nbt.func_150285_a_();
    }

    public static StringNBT createString(String string) {
        return StringNBT.func_229705_a_((String)string);
    }

    public static IntNBT createInt(int value) {
        return IntNBT.func_229692_a_((int)value);
    }

    public static FloatNBT createFloat(float value) {
        return FloatNBT.func_229689_a_((float)value);
    }

    public static DoubleNBT createDouble(double value) {
        return DoubleNBT.func_229684_a_((double)value);
    }

    public static LongNBT createLong(long value) {
        return LongNBT.func_229698_a_((long)value);
    }

    public static ByteNBT createByte(byte value) {
        return ByteNBT.func_229671_a_((byte)value);
    }

    public static ShortNBT createShort(short value) {
        return ShortNBT.func_229701_a_((short)value);
    }

    public static void copyFrom(CompoundNBT target, CompoundNBT source) {
        target.func_197643_a(source);
    }
}

