/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.util.PlayerUtil;
import net.pitan76.mcpitanlib.api.util.ServerUtil;

public class PlayerManagerUtil {
    public static Player getPlayerByUUID(MinecraftServer server, UUID uuid) {
        return PlayerUtil.getPlayerByUUID(server, uuid);
    }

    public static Player getPlayerByName(MinecraftServer server, String name) {
        return PlayerUtil.getPlayerByName(server, name);
    }

    public static List<Player> getPlayersByIP(MinecraftServer server, String ip) {
        return PlayerUtil.getPlayersByIP(server, ip);
    }

    public static List<Player> getPlayers(MinecraftServer server) {
        return PlayerUtil.getPlayers(server);
    }

    public static List<Player> getPlayers(World world) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (PlayerEntity p : world.func_217369_A()) {
            players.add(new Player(p));
        }
        return players;
    }

    public static Player getPlayerByUUID(World world, UUID uuid) {
        return PlayerUtil.getPlayerByUUID(world, uuid);
    }

    public static Player getPlayerByName(World world, String name) {
        return PlayerUtil.getPlayerByName(world, name);
    }

    public static PlayerList getPlayerManager(MinecraftServer server) {
        return ServerUtil.getPlayerManager(server);
    }

    public static PlayerList getPlayerManager(World world) {
        return PlayerManagerUtil.getPlayerManager(world.func_73046_m());
    }

    public static boolean hasPlayerByUUID(PlayerList playerManager, UUID uuid) {
        return playerManager.func_177451_a(uuid) != null;
    }

    public static boolean hasPlayerByName(PlayerList playerManager, String name) {
        return playerManager.func_152612_a(name) != null;
    }

    public static boolean hasPlayerByIP(PlayerList playerManager, String ip) {
        return !playerManager.func_72382_j(ip).isEmpty();
    }

    public static boolean hasPlayerByUUID(MinecraftServer server, UUID uuid) {
        return PlayerManagerUtil.hasPlayerByUUID(PlayerManagerUtil.getPlayerManager(server), uuid);
    }

    public static boolean hasPlayerByName(MinecraftServer server, String name) {
        return PlayerManagerUtil.hasPlayerByName(PlayerManagerUtil.getPlayerManager(server), name);
    }

    public static boolean hasPlayerByIP(MinecraftServer server, String ip) {
        return PlayerManagerUtil.hasPlayerByIP(PlayerManagerUtil.getPlayerManager(server), ip);
    }

    public static boolean hasPlayerByUUID(World world, UUID uuid) {
        return PlayerManagerUtil.hasPlayerByUUID(PlayerManagerUtil.getPlayerManager(world), uuid);
    }

    public static boolean hasPlayerByName(World world, String name) {
        return PlayerManagerUtil.hasPlayerByName(PlayerManagerUtil.getPlayerManager(world), name);
    }

    public static boolean hasPlayerByIP(World world, String ip) {
        return PlayerManagerUtil.hasPlayerByIP(PlayerManagerUtil.getPlayerManager(world), ip);
    }
}

