/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.util.TextUtil;

public class PlayerUtil {
    public static Player getPlayerByUUID(MinecraftServer server, UUID uuid) {
        return new Player((PlayerEntity)server.func_184103_al().func_177451_a(uuid));
    }

    public static Player getPlayerByName(MinecraftServer server, String name) {
        return new Player((PlayerEntity)server.func_184103_al().func_152612_a(name));
    }

    public static List<Player> getPlayersByIP(MinecraftServer server, String ip) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (PlayerEntity p : server.func_184103_al().func_72382_j(ip)) {
            players.add(new Player(p));
        }
        return players;
    }

    public static List<Player> getPlayers(MinecraftServer server) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (PlayerEntity p : server.func_184103_al().func_181057_v()) {
            players.add(new Player(p));
        }
        return players;
    }

    public static Player getPlayerByUUID(World world, UUID uuid) {
        return PlayerUtil.getPlayerByUUID(world.func_73046_m(), uuid);
    }

    public static Player getPlayerByName(World world, String name) {
        return PlayerUtil.getPlayerByName(world.func_73046_m(), name);
    }

    public static boolean isExistByUUID(MinecraftServer server, UUID uuid) {
        return server.func_184103_al().func_177451_a(uuid) != null;
    }

    public static boolean isExistByUUID(World world, UUID uuid) {
        return PlayerUtil.isExistByUUID(world.func_73046_m(), uuid);
    }

    public static boolean isExistByName(MinecraftServer server, String name) {
        return server.func_184103_al().func_152612_a(name) != null;
    }

    public static boolean isExistByName(World world, String name) {
        return PlayerUtil.isExistByName(world.func_73046_m(), name);
    }

    public static boolean isExistByIP(MinecraftServer server, String ip) {
        return !server.func_184103_al().func_72382_j(ip).isEmpty();
    }

    public static boolean isExistByIP(World world, String ip) {
        return PlayerUtil.isExistByIP(world.func_73046_m(), ip);
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage((ITextComponent)TextUtil.literal(message));
    }

    public static float getYaw(Player player) {
        return player.getYaw();
    }

    public static float getPitch(Player player) {
        return player.getPitch();
    }

    public static BlockPos getBlockPos(Player player) {
        return player.getBlockPos();
    }

    public static World getWorld(Player player) {
        return player.getWorld();
    }

    public static boolean isClient(Player player) {
        return player.isClient();
    }

    public static void teleport(Player player, double x, double y, double z) {
        player.teleport(x, y, z);
    }
}

