/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.pitan76.mcpitanlib.api.event.result.EventResult;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;

public class StackActionResult
extends CompatActionResult {
    private final ItemStack stack;
    private final CompatActionResult compatActionResult;
    private boolean isNewStack = false;

    public StackActionResult(ActionResultType actionResult, EventResult eventResult, ItemStack stack) {
        this(new CompatActionResult(actionResult, eventResult), stack);
    }

    public StackActionResult(CompatActionResult actionResult, ItemStack stack) {
        super(null, null);
        this.compatActionResult = actionResult;
        this.stack = stack;
    }

    public void setNewStack(boolean b) {
        this.isNewStack = b;
    }

    @Override
    public ActionResultType toActionResult() {
        return this.compatActionResult.toActionResult();
    }

    @Override
    public EventResult toEventResult() {
        return this.compatActionResult.toEventResult();
    }

    @Override
    @Deprecated
    public Optional<ItemStack> getNewHandStack() {
        if (this.hasNewStack()) {
            return Optional.ofNullable(this.getStack());
        }
        return Optional.empty();
    }

    public boolean hasNewStack() {
        return this.isNewStack;
    }

    public boolean hasStack() {
        return this.getStack() != null;
    }

    public CompatActionResult asCompatActionResult() {
        return this.compatActionResult;
    }

    public static StackActionResult create(CompatActionResult compatActionResult, ItemStack stack) {
        return new StackActionResult(compatActionResult, stack);
    }

    public static StackActionResult create(CompatActionResult compatActionResult) {
        return new StackActionResult(compatActionResult, null);
    }

    public static StackActionResult create(ActionResultType actionResult, EventResult eventResult, ItemStack stack) {
        return new StackActionResult(actionResult, eventResult, stack);
    }

    public static StackActionResult create(ActionResultType actionResult, ItemStack stack) {
        return new StackActionResult(actionResult, null, stack);
    }

    public static StackActionResult create(ActionResult<ItemStack> result) {
        StackActionResult actionResult = StackActionResult.create(CompatActionResult.create(result.func_188397_a()), (ItemStack)result.func_188398_b());
        actionResult.setNewStack(true);
        return actionResult;
    }

    public static StackActionResult success(ItemStack stack) {
        CompatActionResult compatActionResult = CompatActionResult.create(ActionResultType.SUCCESS);
        StackActionResult actionResult = StackActionResult.create(compatActionResult, stack);
        actionResult.setNewStack(true);
        return actionResult;
    }

    public static StackActionResult successServer(ItemStack stack) {
        CompatActionResult compatActionResult = CompatActionResult.create(ActionResultType.SUCCESS);
        StackActionResult actionResult = StackActionResult.create(compatActionResult, stack);
        actionResult.setNewStack(true);
        return actionResult;
    }

    public static StackActionResult consume(ItemStack stack) {
        CompatActionResult compatActionResult = CompatActionResult.create(ActionResultType.CONSUME);
        StackActionResult actionResult = StackActionResult.create(compatActionResult, stack);
        actionResult.setNewStack(true);
        return actionResult;
    }

    public ActionResult<ItemStack> toTypedActionResult() {
        return new ActionResult(this.toActionResult(), (Object)this.getStack());
    }

    public static StackActionResult pass(ItemStack stack) {
        return StackActionResult.create(CompatActionResult.PASS, stack);
    }

    public static StackActionResult pass() {
        return StackActionResult.create(CompatActionResult.PASS);
    }

    public static StackActionResult fail(ItemStack stack) {
        return StackActionResult.create(CompatActionResult.FAIL, stack);
    }

    public static StackActionResult fail() {
        return StackActionResult.create(CompatActionResult.FAIL);
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

