/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.pitan76.mcpitanlib.api.client.render.DrawObjectMV;

public class VertexConsumerUtil {
    public static IVertexBuilder vertex(IVertexBuilder vertexConsumer, float x, float y, float z) {
        return vertexConsumer.func_225582_a_((double)x, (double)y, (double)z);
    }

    public static IVertexBuilder vertex(IVertexBuilder vertexConsumer, MatrixStack stack, float x, float y, float z) {
        return vertexConsumer.func_227888_a_(stack.func_227866_c_().func_227870_a_(), x, y, z);
    }

    public static IVertexBuilder normal(IVertexBuilder vertexConsumer, float x, float y, float z) {
        return vertexConsumer.func_225584_a_(x, y, z);
    }

    public static IVertexBuilder color(IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha) {
        return vertexConsumer.func_227885_a_(red, green, blue, alpha);
    }

    public static IVertexBuilder color(IVertexBuilder vertexConsumer, int red, int green, int blue, int alpha) {
        return vertexConsumer.func_225586_a_(red, green, blue, alpha);
    }

    public static IVertexBuilder colorARGB(IVertexBuilder vertexConsumer, int argb) {
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        int alpha = argb >> 24 & 0xFF;
        return VertexConsumerUtil.color(vertexConsumer, red, green, blue, alpha);
    }

    public static IVertexBuilder colorRGB(IVertexBuilder vertexConsumer, int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        int alpha = 255;
        return VertexConsumerUtil.color(vertexConsumer, red, green, blue, alpha);
    }

    public static IVertexBuilder light(IVertexBuilder vertexConsumer, int light) {
        return vertexConsumer.func_227886_a_(light);
    }

    public static IVertexBuilder overlay(IVertexBuilder vertexConsumer, int overlay) {
        return vertexConsumer.func_227891_b_(overlay);
    }

    public static IVertexBuilder overlayDefaultUV(IVertexBuilder vertexConsumer) {
        return vertexConsumer.func_227891_b_(OverlayTexture.field_229196_a_);
    }

    public static DrawObjectMV vertex(DrawObjectMV drawObject, float x, float y, float z) {
        VertexConsumerUtil.vertex(drawObject.getBuffer(), drawObject.getStack(), x, y, z);
        return drawObject;
    }

    public static DrawObjectMV normal(DrawObjectMV drawObject, float x, float y, float z) {
        VertexConsumerUtil.normal(drawObject.getBuffer(), x, y, z);
        return drawObject;
    }

    public static DrawObjectMV color(DrawObjectMV drawObject, float red, float green, float blue, float alpha) {
        VertexConsumerUtil.color(drawObject.getBuffer(), red, green, blue, alpha);
        return drawObject;
    }

    public static DrawObjectMV color(DrawObjectMV drawObject, int red, int green, int blue, int alpha) {
        VertexConsumerUtil.color(drawObject.getBuffer(), red, green, blue, alpha);
        return drawObject;
    }

    public static DrawObjectMV colorARGB(DrawObjectMV drawObject, int argb) {
        VertexConsumerUtil.colorARGB(drawObject.getBuffer(), argb);
        return drawObject;
    }

    public static DrawObjectMV colorRGB(DrawObjectMV drawObject, int rgb) {
        VertexConsumerUtil.colorRGB(drawObject.getBuffer(), rgb);
        return drawObject;
    }

    public static DrawObjectMV light(DrawObjectMV drawObject, int light) {
        VertexConsumerUtil.light(drawObject.getBuffer(), light);
        return drawObject;
    }

    public static DrawObjectMV overlay(DrawObjectMV drawObject, int overlay) {
        VertexConsumerUtil.overlay(drawObject.getBuffer(), overlay);
        return drawObject;
    }

    public static DrawObjectMV overlayDefaultUV(DrawObjectMV drawObject) {
        VertexConsumerUtil.overlayDefaultUV(drawObject.getBuffer());
        return drawObject;
    }

    public static IVertexBuilder texture(IVertexBuilder vertexConsumer, float u, float v) {
        return vertexConsumer.func_225583_a_(u, v);
    }

    public static IVertexBuilder vertex(IVertexBuilder vertexConsumer, Matrix4f matrix4f, float x, float y, float z) {
        return vertexConsumer.func_227888_a_(matrix4f, x, y, z);
    }

    public static IVertexBuilder normal(IVertexBuilder vertexConsumer, MatrixStack stack, float x, float y, float z) {
        return vertexConsumer.func_227887_a_(stack.func_227866_c_().func_227872_b_(), x, y, z);
    }

    public static IVertexBuilder next(IVertexBuilder vertexConsumer) {
        vertexConsumer.func_181675_d();
        return vertexConsumer;
    }

    public static void renderQuad(IVertexBuilder vertexConsumer, MatrixStack stack, Matrix4f matrix4f, Matrix3f matrix3f, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ, int r, int g, int b, int alpha, int u, int v, int overlay, int light) {
        Object vertexes = new float[4][3];
        if (Math.abs(normalY) > 0.5f) {
            vertexes = normalY > 0.0f ? (Object)new float[][]{{x1, y1, z1}, {x1, y1, z2}, {x2, y1, z2}, {x2, y1, z1}} : (Object)new float[][]{{x1, y1, z1}, {x2, y1, z1}, {x2, y1, z2}, {x1, y1, z2}};
        } else if (Math.abs(normalZ) > 0.5f) {
            vertexes = normalZ > 0.0f ? (Object)new float[][]{{x1, y1, z1}, {x2, y1, z1}, {x2, y2, z1}, {x1, y2, z1}} : (Object)new float[][]{{x1, y1, z1}, {x1, y2, z1}, {x2, y2, z1}, {x2, y1, z1}};
        } else if (Math.abs(normalX) > 0.5f) {
            vertexes = normalX > 0.0f ? (Object)new float[][]{{x1, y1, z1}, {x1, y2, z1}, {x1, y2, z2}, {x1, y1, z2}} : (Object)new float[][]{{x1, y1, z1}, {x1, y1, z2}, {x1, y2, z2}, {x1, y2, z1}};
        }
        for (float[] vertex : vertexes) {
            if (vertex.length != 3) continue;
            VertexConsumerUtil.vertex(vertexConsumer, matrix4f, vertex[0], vertex[1], vertex[2]);
            VertexConsumerUtil.color(vertexConsumer, r, g, b, alpha);
            VertexConsumerUtil.texture(vertexConsumer, u, v);
            VertexConsumerUtil.light(vertexConsumer, light);
            VertexConsumerUtil.normal(vertexConsumer, stack, normalX, normalY, normalZ);
            VertexConsumerUtil.next(vertexConsumer);
        }
    }

    public static void renderQuad(DrawObjectMV drawObject, Matrix4f matrix4f, Matrix3f matrix3f, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ, int r, int g, int b, int alpha, int u, int v, int overlay, int light) {
        VertexConsumerUtil.renderQuad(drawObject.getBuffer(), drawObject.getStack(), matrix4f, matrix3f, x1, y1, z1, x2, y2, z2, normalX, normalY, normalZ, r, g, b, alpha, u, v, overlay, light);
    }

    public static void renderQuad(DrawObjectMV drawObject, float x1, float y1, float z1, float x2, float y2, float z2, float normalX, float normalY, float normalZ, int r, int g, int b, int alpha, int u, int v, int overlay, int light) {
        Matrix4f matrix4f = drawObject.getMatrix4f();
        Matrix3f matrix3f = drawObject.getMatrix3f();
        VertexConsumerUtil.renderQuad(drawObject.getBuffer(), drawObject.getStack(), matrix4f, matrix3f, x1, y1, z1, x2, y2, z2, normalX, normalY, normalZ, r, g, b, alpha, u, v, overlay, light);
    }
}

