/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.nbt;

import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class NbtListUtil {
    public static ListNBT create() {
        return NbtUtil.createNbtList();
    }

    public static ListNBT copy(ListNBT list) {
        return list.func_74737_b();
    }

    public static Stream<INBT> stream(ListNBT list) {
        return list.stream();
    }

    public static Optional<String> getStringOptional(ListNBT list, int index) {
        if (index < 0 || index >= list.size()) {
            return Optional.empty();
        }
        return Optional.of(list.func_150307_f(index));
    }

    public static INBT get(ListNBT list, int index) {
        return list.get(index);
    }

    public static INBT getOrDefault(ListNBT list, int index, INBT defaultValue) {
        INBT nbt = NbtListUtil.get(list, index);
        return nbt == null ? defaultValue : nbt;
    }

    public static void set(ListNBT list, int index, INBT value) {
        list.set(index, value);
    }

    public static void add(ListNBT list, INBT value) {
        list.add((Object)value);
    }

    public static void set(ListNBT list, int index, String value) {
        NbtListUtil.set(list, index, (INBT)NbtUtil.createString(value));
    }

    public static boolean has(ListNBT list, INBT value) {
        return list.contains((Object)value);
    }

    public static int size(ListNBT list) {
        return list.size();
    }

    public static void remove(ListNBT list, int index) {
        list.remove(index);
    }

    public static void clear(ListNBT list) {
        list.clear();
    }

    public static boolean isEmpty(ListNBT list) {
        return list.isEmpty();
    }

    public static String getString(ListNBT list, int index) {
        return NbtListUtil.getStringOptional(list, index).orElse("");
    }

    public static void setString(ListNBT list, int index, String value) {
        list.set(index, (INBT)NbtUtil.createString(value));
    }

    public static void addString(ListNBT list, String value) {
        list.add((Object)NbtUtil.createString(value));
    }

    public static ListNBT getList(ListNBT list, int index) {
        return list.func_202169_e(index);
    }

    public static CompoundNBT getCompound(ListNBT list, int index) {
        return list.func_150305_b(index);
    }
}

