/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.recipe;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.recipe.v3.CompatRecipe;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.midohra.recipe.CraftingRecipe;
import net.pitan76.mcpitanlib.midohra.recipe.RecipeType;
import net.pitan76.mcpitanlib.midohra.recipe.entry.CraftingRecipeEntry;
import net.pitan76.mcpitanlib.midohra.recipe.entry.RecipeEntry;

public class RecipeUtil {
    public static Collection<IRecipe<?>> getMCRecipes(World world) {
        return world.func_199532_z().func_199510_b();
    }

    public static Collection<CompatRecipe> getRecipes(World world) {
        ArrayList<CompatRecipe> recipes = new ArrayList<CompatRecipe>();
        for (IRecipe<?> recipe : RecipeUtil.getMCRecipes(world)) {
            recipes.add(new CompatRecipe(recipe, recipe.func_199560_c()));
        }
        return recipes;
    }

    public static Collection<CompatRecipe> getRecipesByType(World world, IRecipeType<?> type) {
        ArrayList<CompatRecipe> recipes = new ArrayList<CompatRecipe>();
        for (IRecipe<?> recipe : RecipeUtil.getMCRecipes(world)) {
            if (recipe.func_222127_g() != type) continue;
            recipes.add(new CompatRecipe(recipe, recipe.func_199560_c()));
        }
        return recipes;
    }

    public static Collection<CompatRecipe> getRecipes(net.pitan76.mcpitanlib.midohra.world.World world) {
        return RecipeUtil.getRecipes(world.getRaw());
    }

    public static Collection<CompatRecipe> getRecipesByType(net.pitan76.mcpitanlib.midohra.world.World world, RecipeType type) {
        return RecipeUtil.getRecipesByType(world.getRaw(), type.getRaw());
    }

    public static Collection<RecipeEntry> getRecipeEntries(net.pitan76.mcpitanlib.midohra.world.World world) {
        ArrayList<RecipeEntry> entries = new ArrayList<RecipeEntry>();
        for (IRecipe<?> recipe : RecipeUtil.getMCRecipes(world.getRaw())) {
            entries.add(RecipeEntry.of(recipe, CompatIdentifier.fromMinecraft(recipe.func_199560_c())));
        }
        return entries;
    }

    public static Collection<CraftingRecipe> getCraftingRecipes(net.pitan76.mcpitanlib.midohra.world.World world) {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (CompatRecipe recipe : RecipeUtil.getRecipesByType(world, RecipeType.CRAFTING)) {
            if (!(recipe.getRecipe() instanceof ICraftingRecipe)) continue;
            recipes.add(CraftingRecipe.of((ICraftingRecipe)recipe.getRecipe()));
        }
        return recipes;
    }

    public static Collection<CraftingRecipeEntry> getCraftingRecipeEntries(net.pitan76.mcpitanlib.midohra.world.World world) {
        ArrayList<CraftingRecipeEntry> entries = new ArrayList<CraftingRecipeEntry>();
        for (IRecipe<?> recipe : RecipeUtil.getMCRecipes(world.getRaw())) {
            if (!(recipe instanceof ICraftingRecipe)) continue;
            entries.add(CraftingRecipeEntry.of((ICraftingRecipe)recipe, CompatIdentifier.fromMinecraft(recipe.func_199560_c())));
        }
        return entries;
    }
}

