/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.world;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class WorldViewUtil {
    public static boolean isClient(IWorldReader world) {
        return world.func_201670_d();
    }

    public static BlockState getBlockState(IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public static Block getBlock(IWorldReader world, BlockPos pos) {
        return WorldViewUtil.getBlockState(world, pos).func_177230_c();
    }

    public static TileEntity getBlockEntity(IWorldReader world, BlockPos pos) {
        return world.func_175625_s(pos);
    }

    public static <T extends TileEntity> Optional<T> getBlockEntity(IWorldReader world, BlockPos pos, TileEntityType<T> type) {
        return Optional.ofNullable(type.func_226986_a_((IBlockReader)world, pos));
    }

    public static FluidState getFluidState(IWorldReader world, BlockPos pos) {
        return WorldViewUtil.getBlockState(world, pos).func_204520_s();
    }

    public static Fluid getFluid(IWorldReader world, BlockPos pos) {
        return WorldViewUtil.getFluidState(world, pos).func_206886_c();
    }

    public static int getBottomY(IWorldReader world) {
        return 0;
    }

    public static int getTopY(IWorldReader world) {
        return world.func_217301_I();
    }

    public static boolean isChunkLoaded(IWorldReader world, BlockPos pos) {
        return world.func_175667_e(pos);
    }

    public static boolean isRegionLoaded(IWorldReader world, BlockPos min, BlockPos max) {
        return world.func_175707_a(min, max);
    }

    public static DimensionType getDimensionType(IWorldReader world) {
        return world.func_230315_m_();
    }

    public static boolean isAirBlock(IWorldReader world, BlockPos pos) {
        return WorldViewUtil.getBlockState(world, pos).func_196958_f();
    }

    public static boolean isOpaqueBlock(IWorldReader world, BlockPos pos) {
        return WorldViewUtil.getBlockState(world, pos).func_200132_m();
    }

    public static boolean isWater(IWorldReader world, BlockPos pos) {
        return WorldViewUtil.getFluidState(world, pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }
}

