/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.component;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.pitan76.mcpitanlib.api.item.stack.LoreUtil;
import net.pitan76.mcpitanlib.api.util.BlockEntityDataUtil;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.midohra.component.item.CustomNameComponentType;
import net.pitan76.mcpitanlib.midohra.component.item.ItemComponentType;
import net.pitan76.mcpitanlib.midohra.component.item.RarityComponentType;

public class ItemComponentTypes {
    public static final ItemComponentType<CompoundNBT> CUSTOM_DATA = new ItemComponentType<CompoundNBT>("components.minecraft:custom_data"){

        @Override
        public void put(ItemStack stack, CompoundNBT value) {
            CustomDataUtil.setNbt(stack, value);
        }

        @Override
        public CompoundNBT get(ItemStack stack) {
            return CustomDataUtil.getNbt(stack);
        }

        @Override
        public boolean has(ItemStack stack) {
            return CustomDataUtil.hasNbt(stack);
        }
    };
    public static final ItemComponentType<Integer> MAX_STACK_SIZE = new ItemComponentType<Integer>("components.minecraft:max_stack_size"){

        @Override
        public void put(ItemStack stack, Integer value) {
        }

        @Override
        public boolean has(ItemStack stack) {
            return false;
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.func_77976_d();
        }
    };
    public static final ItemComponentType<Integer> MAX_DAMAGE = new ItemComponentType<Integer>("components.minecraft:max_damage"){

        @Override
        public void put(ItemStack stack, Integer value) {
        }

        @Override
        public boolean has(ItemStack stack) {
            return false;
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.func_77958_k();
        }
    };
    public static final ItemComponentType<Integer> DAMAGE = new ItemComponentType<Integer>("Damage"){

        @Override
        public void put(ItemStack stack, Integer value) {
            stack.func_196085_b(value.intValue());
        }

        @Override
        public boolean has(ItemStack stack) {
            return stack.func_77942_o() && NbtUtil.has(stack.func_77978_p(), "Damage");
        }

        @Override
        public Integer get(ItemStack stack) {
            return stack.func_77952_i();
        }
    };
    public static final ItemComponentType<Boolean> UNBREAKABLE = new ItemComponentType<Boolean>("Unbreakable"){

        @Override
        public void put(ItemStack stack, Boolean value) {
            if (value.booleanValue()) {
                stack.func_77978_p().func_74757_a("Unbreakable", true);
            } else {
                stack.func_196083_e("Unbreakable");
            }
        }

        @Override
        public Boolean get(ItemStack stack) {
            return this.has(stack);
        }
    };
    public static final ItemComponentType<Rarity> RARITY = new RarityComponentType();
    public static final CustomNameComponentType CUSTOM_NAME = new CustomNameComponentType();
    public static final ItemComponentType<CompoundNBT> BLOCK_ENTITY_DATA = new ItemComponentType<CompoundNBT>("BlockEntityTag"){

        @Override
        public void put(ItemStack stack, CompoundNBT value) {
            BlockEntityDataUtil.setBlockEntityNbt(stack, value);
        }

        @Override
        public boolean has(ItemStack stack) {
            return BlockEntityDataUtil.hasBlockEntityNbt(stack);
        }

        @Override
        public CompoundNBT get(ItemStack stack) {
            return BlockEntityDataUtil.getBlockEntityNbt(stack);
        }
    };
    public static final ItemComponentType<CompoundNBT> ENTITY_DATA = new ItemComponentType<CompoundNBT>("EntityTag"){

        @Override
        public void put(ItemStack stack, CompoundNBT value) {
            stack.func_77983_a("EntityTag", (INBT)value);
        }

        @Override
        public boolean has(ItemStack stack) {
            return stack.func_77942_o() && NbtUtil.has(stack.func_77978_p(), "EntityTag");
        }

        @Override
        public CompoundNBT get(ItemStack stack) {
            return stack.func_179543_a("EntityTag");
        }
    };
    public static final ItemComponentType<List<ITextComponent>> LORE = new ItemComponentType<List<ITextComponent>>("display.Lore"){

        @Override
        public void put(ItemStack stack, List<ITextComponent> value) {
            LoreUtil.setLore(stack, value);
        }

        @Override
        public boolean has(ItemStack stack) {
            return LoreUtil.hasLore(stack);
        }

        @Override
        public List<ITextComponent> get(ItemStack stack) {
            return LoreUtil.getLore(stack);
        }
    };
}

