/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.fluid;

import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.FluidStateUtil;
import net.pitan76.mcpitanlib.api.util.FluidUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import org.jetbrains.annotations.Nullable;

public class FluidWrapper {
    private final Fluid fluid;

    protected FluidWrapper() {
        this.fluid = null;
    }

    protected FluidWrapper(Fluid fluid) {
        this.fluid = fluid;
    }

    public static FluidWrapper of(Fluid fluid) {
        return new FluidWrapper(fluid);
    }

    public static FluidWrapper of() {
        return new FluidWrapper();
    }

    public static FluidWrapper of(CompatIdentifier id) {
        if (FluidUtil.isExist(id)) {
            return FluidWrapper.of(FluidUtil.fromId(id));
        }
        return FluidWrapper.of();
    }

    public static FluidWrapper of(CompatIdentifier id, CompatIdentifier ... ids) {
        if (FluidWrapper.of(id).isExist()) {
            return FluidWrapper.of(id);
        }
        for (CompatIdentifier id1 : ids) {
            if (!FluidWrapper.of(id1).isExist()) continue;
            return FluidWrapper.of(id1);
        }
        return FluidWrapper.of();
    }

    public boolean isExist() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    @Nullable
    public Fluid get() {
        return this.fluid;
    }

    public Fluid gerOrDefault(Fluid defaultFluid) {
        return this.isEmpty() ? defaultFluid : this.get();
    }

    public CompatIdentifier getId() {
        if (this.isEmpty()) {
            return CompatIdentifier.empty();
        }
        return FluidUtil.toCompatId(this.get());
    }

    public String getName() {
        if (this.isEmpty()) {
            return "";
        }
        return this.get().toString();
    }

    public FluidState getDefaultState() {
        return FluidStateUtil.getDefaultState(this.get());
    }

    public ItemWrapper getBucketItem() {
        return ItemWrapper.of(FluidUtil.getBucketItem(this.get()));
    }

    public boolean rawEquals(FluidWrapper fluid) {
        return this.get() == fluid.get();
    }
}

