/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.item;

import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.enchantment.CompatEnchantment;
import net.pitan76.mcpitanlib.api.item.stack.LoreUtil;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.EnchantmentUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import org.jetbrains.annotations.Nullable;

public class ItemStack {
    private final net.minecraft.item.ItemStack stack;
    public static final ItemStack EMPTY = new ItemStack(ItemStackUtil.empty());

    protected ItemStack(net.minecraft.item.ItemStack stack) {
        this.stack = stack;
    }

    public static ItemStack of(net.minecraft.item.ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return EMPTY;
        }
        return new ItemStack(stack);
    }

    public static ItemStack of(IItemProvider item) {
        return new Builder().item(item).build();
    }

    public static ItemStack of(IItemProvider item, int count) {
        return new Builder().item(item).count(count).build();
    }

    public static ItemStack empty() {
        return EMPTY;
    }

    public int getCount() {
        return this.stack.func_190916_E();
    }

    public void setCount(int count) {
        this.stack.func_190920_e(count);
    }

    public CompoundNBT getCustomNbt() {
        return CustomDataUtil.getNbt(this.stack);
    }

    public void setCustomNbt(CompoundNBT nbt) {
        CustomDataUtil.setNbt(this.stack, nbt);
    }

    public void removeCustomNbt() {
        CustomDataUtil.remove(this.stack);
    }

    public boolean hasCustomNbt() {
        return CustomDataUtil.hasNbt(this.stack);
    }

    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    public CompatIdentifier getItemId() {
        return ItemUtil.toCompatID(this.stack.func_77973_b());
    }

    public ItemStack copy() {
        return new ItemStack(this.stack.func_77946_l());
    }

    public ItemStack copyWithCount(int count) {
        return new ItemStack(ItemStackUtil.copyWithCount(this.stack, count));
    }

    public Map<CompatEnchantment, Integer> getEnchantments(@Nullable World world) {
        return EnchantmentUtil.getEnchantment(this.stack, world);
    }

    public void setEnchantments(Map<CompatEnchantment, Integer> enchantments, @Nullable World world) {
        EnchantmentUtil.setEnchantment(this.stack, enchantments, world);
    }

    public int getMaxCount() {
        return ItemStackUtil.getMaxCount(this.stack);
    }

    public boolean hasLore() {
        return LoreUtil.hasLore(this.stack);
    }

    public List<ITextComponent> getLore() {
        return LoreUtil.getLore(this.stack);
    }

    public List<String> getLoreAsStringList() {
        return LoreUtil.getLoreAsStringList(this.stack);
    }

    public void setLore(List<ITextComponent> lore) {
        LoreUtil.setLore(this.stack, lore);
    }

    public void setLoreString(List<String> lore) {
        LoreUtil.setLoreStringList(this.stack, lore);
    }

    public void setLore(String lore) {
        LoreUtil.setLore(this.stack, lore);
    }

    @Deprecated
    public net.minecraft.item.ItemStack toMinecraft() {
        return this.stack;
    }

    public ItemWrapper getItem() {
        if (this.isEmpty()) {
            return ItemWrapper.of();
        }
        return ItemWrapper.of(this.getRawItem());
    }

    public Item getRawItem() {
        return ItemStackUtil.getItem(this.stack);
    }

    public String toString() {
        return this.stack.toString();
    }

    public static class Builder {
        protected CompatIdentifier id;
        protected int count = 1;
        protected CompoundNBT nbt = NbtUtil.create();

        public Builder item(CompatIdentifier id) {
            this.id = id;
            return this;
        }

        public Builder item(IItemProvider item) {
            this.id = ItemUtil.toCompatID(item.func_199767_j());
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder nbt(CompoundNBT nbt) {
            this.nbt = nbt;
            return this;
        }

        public ItemStack build() {
            net.minecraft.item.ItemStack stack = new net.minecraft.item.ItemStack((IItemProvider)ItemUtil.fromId(this.id), this.count);
            CustomDataUtil.setNbt(stack, this.nbt);
            return new ItemStack(stack);
        }
    }
}

