/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.server;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.BanList;
import net.minecraft.server.management.IPBanList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.WhiteList;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.midohra.server.MCServer;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.World;

public class PlayerManager {
    private final PlayerList playerManager;

    protected PlayerManager(PlayerList playerManager) {
        this.playerManager = playerManager;
    }

    public static PlayerManager of(PlayerList playerManager) {
        return new PlayerManager(playerManager);
    }

    public static PlayerManager of(MinecraftServer server) {
        return PlayerManager.of(server.func_184103_al());
    }

    public static PlayerManager of(MCServer server) {
        return PlayerManager.of(server.getRaw());
    }

    public static PlayerManager of(ServerWorld world) {
        return PlayerManager.of(world.getServer());
    }

    public static PlayerManager of(World world) {
        return PlayerManager.of(world.getServer());
    }

    public PlayerList getRaw() {
        return this.playerManager;
    }

    public PlayerList toMinecraft() {
        return this.getRaw();
    }

    public void broadcast(TextComponent message, boolean overlay) {
        if (overlay) {
            this.getRaw().func_232641_a_(message.getText(), ChatType.SYSTEM, UUID.randomUUID());
        } else {
            this.getRaw().func_232641_a_(message.getText(), ChatType.CHAT, UUID.randomUUID());
        }
    }

    public void broadcast(TextComponent message) {
        this.broadcast(message, false);
    }

    public void broadcast(String message, boolean overlay) {
        if (overlay) {
            this.getRaw().func_232641_a_((ITextComponent)TextUtil.literal(message), ChatType.SYSTEM, UUID.randomUUID());
        } else {
            this.getRaw().func_232641_a_((ITextComponent)TextUtil.literal(message), ChatType.CHAT, UUID.randomUUID());
        }
    }

    public void broadcast(String message) {
        this.broadcast(message, false);
    }

    public void removePlayer(Player player) {
        this.getRaw().func_72367_e(player.getServerPlayer().get());
    }

    public Player getPlayerByUUID(UUID uuid) {
        return new Player((PlayerEntity)this.getRaw().func_177451_a(uuid));
    }

    public Player getPlayerByName(String name) {
        return new Player((PlayerEntity)this.getRaw().func_152612_a(name));
    }

    public List<Player> getPlayersByIP(String ip) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (PlayerEntity p : this.getRaw().func_72382_j(ip)) {
            players.add(new Player(p));
        }
        return players;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (PlayerEntity p : this.getRaw().func_181057_v()) {
            players.add(new Player(p));
        }
        return players;
    }

    public boolean isExistByUUID(UUID uuid) {
        return this.getRaw().func_177451_a(uuid) != null;
    }

    public boolean isExistByName(String name) {
        return this.getRaw().func_152612_a(name) != null;
    }

    public boolean isExistByIP(String ip) {
        return !this.getRaw().func_72382_j(ip).isEmpty();
    }

    public boolean hasPlayerByUUID(UUID uuid) {
        return this.getRaw().func_177451_a(uuid) != null;
    }

    public boolean hasPlayerByName(String name) {
        return this.getRaw().func_152612_a(name) != null;
    }

    public boolean hasPlayerByIP(String ip) {
        return !this.getRaw().func_72382_j(ip).isEmpty();
    }

    public int getCurrentPlayerCount() {
        return this.getRaw().func_72394_k();
    }

    public int getMaxPlayerCount() {
        return this.getRaw().func_72352_l();
    }

    public boolean isWhitelistEnabled() {
        return this.getRaw().func_72383_n();
    }

    public void setWhitelistEnabled(boolean enabled) {
        this.getRaw().func_72371_a(enabled);
    }

    public WhiteList getWhitelist() {
        return this.getRaw().func_152599_k();
    }

    public void reloadWhitelist() {
        this.getRaw().func_187244_a();
    }

    public IPBanList getBannedIpList() {
        return this.getRaw().func_72363_f();
    }

    public BanList getBannedPlayerList() {
        return this.getRaw().func_152608_h();
    }
}

