/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.util.math;

import java.util.stream.Stream;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;

public class ChunkPos {
    private final net.minecraft.util.math.ChunkPos pos;

    protected ChunkPos(net.minecraft.util.math.ChunkPos pos) {
        this.pos = pos;
    }

    public static ChunkPos of(net.minecraft.util.math.ChunkPos pos) {
        return new ChunkPos(pos);
    }

    public static ChunkPos of(int x, int z) {
        return ChunkPos.of(new net.minecraft.util.math.ChunkPos(x, z));
    }

    public static ChunkPos of(BlockPos pos) {
        return ChunkPos.of(new net.minecraft.util.math.ChunkPos(pos.toMinecraft()));
    }

    public static ChunkPos of(long pos) {
        return ChunkPos.of(new net.minecraft.util.math.ChunkPos(pos));
    }

    public static ChunkPos fromRegion(int x, int z) {
        return ChunkPos.of(x << 5, z << 5);
    }

    public static ChunkPos fromRegionCenter(int x, int z) {
        return ChunkPos.of(x - 16, z - 16);
    }

    public net.minecraft.util.math.ChunkPos getRaw() {
        return this.pos;
    }

    public net.minecraft.util.math.ChunkPos toMinecraft() {
        return this.getRaw();
    }

    public int getX() {
        return this.getRaw().field_77276_a;
    }

    public int getZ() {
        return this.getRaw().field_77275_b;
    }

    public int getOffsetX(int offsetX) {
        return this.getStartX() + offsetX;
    }

    public int getOffsetZ(int offsetZ) {
        return this.getStartX() + offsetZ;
    }

    public int getStartX() {
        return this.getRaw().func_180334_c();
    }

    public int getStartZ() {
        return this.getRaw().func_180333_d();
    }

    public int getEndX() {
        return this.getRaw().func_180332_e();
    }

    public int getEndZ() {
        return this.getRaw().func_180330_f();
    }

    public int getCenterX() {
        return this.getStartX() + 8;
    }

    public int getCenterZ() {
        return this.getStartZ() + 8;
    }

    public int getRegionX() {
        return this.getRaw().func_222241_h();
    }

    public int getRegionZ() {
        return this.getRaw().func_222242_i();
    }

    public int getRegionRelativeX() {
        return this.getRaw().func_222240_j();
    }

    public int getRegionRelativeZ() {
        return this.getRaw().func_222238_k();
    }

    public BlockPos getStartPos() {
        return BlockPos.of(this.getRaw().func_206849_h());
    }

    public BlockPos getCenterAtY(int y) {
        return BlockPos.of(this.getCenterX(), y, this.getCenterZ());
    }

    public BlockPos getBlockPos(int offsetX, int y, int offsetZ) {
        return BlockPos.of(this.getOffsetX(offsetX), y, this.getOffsetZ(offsetZ));
    }

    public long toLong() {
        return this.getRaw().func_201841_a();
    }

    public String toString() {
        return this.getRaw().toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChunkPos && this.getRaw().equals((Object)((ChunkPos)obj).getRaw());
    }

    public int hashCode() {
        return this.getRaw().hashCode();
    }

    public int getChebyshevDistance(ChunkPos pos) {
        return Math.max(Math.abs(this.getX() - pos.getX()), Math.abs(this.getZ() - pos.getZ()));
    }

    public int getChebyshevDistance(int x, int z) {
        return this.getChebyshevDistance(ChunkPos.of(x, z));
    }

    public int getSquaredDistance(ChunkPos pos) {
        int dx = this.getX() - pos.getX();
        int dz = this.getZ() - pos.getZ();
        return dx * dx + dz * dz;
    }

    public int getSquaredDistance(long pos) {
        return this.getSquaredDistance(ChunkPos.of(pos));
    }

    public static Stream<ChunkPos> stream(ChunkPos center, int radius) {
        return net.minecraft.util.math.ChunkPos.func_222243_a((net.minecraft.util.math.ChunkPos)center.getRaw(), (int)radius).map(ChunkPos::of);
    }

    public static Stream<ChunkPos> stream(ChunkPos pos1, ChunkPos pos2) {
        return net.minecraft.util.math.ChunkPos.func_222239_a((net.minecraft.util.math.ChunkPos)pos1.getRaw(), (net.minecraft.util.math.ChunkPos)pos2.getRaw()).map(ChunkPos::of);
    }
}

