/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world;

import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.pitan76.mcpitanlib.api.util.world.WorldAccessUtil;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.RedstoneView;

public class WorldView
implements IWorldView,
RedstoneView {
    private final IWorldReader world;

    protected WorldView(IWorldReader world) {
        this.world = world;
    }

    public static WorldView of(IWorldReader world) {
        return new WorldView(world);
    }

    protected IWorldReader getRaw() {
        return this.world;
    }

    public IWorldReader toMinecraft() {
        return this.getRaw();
    }

    public boolean isClient() {
        return WorldAccessUtil.isClient(this.getRaw());
    }

    public boolean isServer() {
        return !this.isClient();
    }

    @Override
    public BlockEntityWrapper getBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return BlockEntityWrapper.of(WorldAccessUtil.getBlockEntity(this.getRaw(), pos.toMinecraft()));
    }

    public <T extends TileEntity> Optional<T> getRawBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, TileEntityType<T> type) {
        return WorldAccessUtil.getBlockEntity(this.getRaw(), pos.toMinecraft(), type);
    }

    public <T extends TileEntity> BlockEntityWrapper getBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, TileEntityType<T> type) {
        Optional<TileEntity> blockEntity = WorldAccessUtil.getBlockEntity(this.getRaw(), pos.toMinecraft(), type);
        return blockEntity.map(BlockEntityWrapper::of).orElse(BlockEntityWrapper.of());
    }

    @Override
    public TileEntity getBlockEntity(BlockPos pos) {
        return this.getRaw().func_175625_s(pos);
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        return this.getRaw().func_180495_p(pos);
    }

    @Override
    public FluidState getFluidState(BlockPos pos) {
        return this.getRaw().func_204610_c(pos);
    }

    @Override
    @Deprecated
    public IWorldReader getRedstoneView() {
        return this.getRaw();
    }
}

