/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.mixin;

import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.pitan76.mcpitanlib.api.block.ExtendBlockProvider;
import net.pitan76.mcpitanlib.api.event.block.BlockScheduledTickEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockUseEvent;
import net.pitan76.mcpitanlib.api.event.block.CanPathfindThroughArgs;
import net.pitan76.mcpitanlib.api.event.block.CollisionShapeEvent;
import net.pitan76.mcpitanlib.api.event.block.DroppedStacksArgs;
import net.pitan76.mcpitanlib.api.event.block.OutlineShapeEvent;
import net.pitan76.mcpitanlib.api.event.block.ScreenHandlerCreateEvent;
import net.pitan76.mcpitanlib.api.event.block.StateReplacedEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractBlock.class})
public class AbstractBlockMixin {
    @Inject(method={"getCollisionShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_getCollisionShape(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            VoxelShape returnValue = provider.getCollisionShape(new CollisionShapeEvent(state, world, pos, context), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"getOutlineShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_getOutlineShape(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            VoxelShape returnValue = provider.getOutlineShape(new OutlineShapeEvent(state, world, pos, context), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"scheduledTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_scheduledTick(BlockState state, ServerWorld world, BlockPos pos, Random random, CallbackInfo ci) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.scheduledTick(new BlockScheduledTickEvent(state, world, pos, random), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"onUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_onUse(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit, CallbackInfoReturnable<ActionResultType> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            CompatActionResult returnValue = provider.onRightClick(new BlockUseEvent(state, world, pos, player, hand, hit), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue.toActionResult());
            }
        }
    }

    @Inject(method={"createScreenHandlerFactory"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_createScreenHandlerFactory(BlockState state, World world, BlockPos pos, CallbackInfoReturnable<INamedContainerProvider> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            SimpleNamedContainerProvider returnValue = new SimpleNamedContainerProvider((syncId, inventory, player) -> provider.createScreenHandler(new ScreenHandlerCreateEvent(state, world, pos, syncId, inventory, player), options), provider.getScreenTitle());
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"onStateReplaced"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_onStateReplaced(BlockState state, World world, BlockPos pos, BlockState newState, boolean moved, CallbackInfo ci) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.onStateReplaced(new StateReplacedEvent(state, world, pos, newState, moved), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"getDroppedStacks"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_getDroppedStacks(BlockState state, LootContext.Builder builder, CallbackInfoReturnable<List<ItemStack>> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            List<ItemStack> returnValue = provider.getDroppedStacks(new DroppedStacksArgs(state, builder), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue(returnValue);
            }
        }
    }

    @Inject(method={"canPathfindThrough"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$inject_canPathfindThrough(BlockState state, IBlockReader world, BlockPos pos, PathType type, CallbackInfoReturnable<Boolean> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            Boolean returnValue = provider.canPathfindThrough(new CanPathfindThroughArgs(state, world, pos, type), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }
}

