/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.mixin;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.pitan76.mcpitanlib.api.block.ExtendBlockProvider;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.event.block.BlockBreakEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockPlacedEvent;
import net.pitan76.mcpitanlib.api.event.block.PickStackEvent;
import net.pitan76.mcpitanlib.api.event.block.PlacementStateArgs;
import net.pitan76.mcpitanlib.api.event.block.result.BlockBreakResult;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.event.v1.listener.BlockBreakTask;
import net.pitan76.mcpitanlib.api.event.v1.listener.BlockPlacedTask;
import net.pitan76.mcpitanlib.api.event.v2.BlockEventRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin {
    @Inject(method={"onPlaced"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$onPlaced(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, CallbackInfo ci) {
        if (!BlockEventRegistry.ON_PLACED.isEmpty()) {
            int maxPriority;
            for (int p = maxPriority = BlockEventRegistry.ON_PLACED.getMaxPriority(); p >= 0; --p) {
                for (BlockPlacedTask listener : BlockEventRegistry.ON_PLACED.getListenersAsList(p)) {
                    listener.onPlaced(new BlockPlacedEvent(world, pos, state, placer, stack));
                }
            }
        }
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.onPlaced(new BlockPlacedEvent(world, pos, state, placer, stack), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"onBreak"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$onBreak(World world, BlockPos pos, BlockState state, PlayerEntity player, CallbackInfo ci) {
        if (!BlockEventRegistry.ON_BREAK.isEmpty()) {
            int maxPriority;
            for (int p = maxPriority = BlockEventRegistry.ON_BREAK.getMaxPriority(); p >= 0; --p) {
                for (BlockBreakTask listener : BlockEventRegistry.ON_BREAK.getListenersAsList(p)) {
                    listener.onBreak(new BlockBreakEvent(world, pos, state, player));
                }
            }
        }
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            BlockBreakResult returnValue = provider.onBreak(new BlockBreakEvent(world, pos, state, player), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"getPickStack"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getPickStack(IBlockReader world, BlockPos pos, BlockState state, CallbackInfoReturnable<ItemStack> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            ItemStack returnValue = provider.getPickStack(new PickStackEvent(world, pos, state), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"appendProperties"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$appendProperties(StateContainer.Builder<Block, BlockState> builder, CallbackInfo ci) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.appendProperties(new AppendPropertiesArgs(builder), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"getPlacementState"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getPlacementState(BlockItemUseContext ctx, CallbackInfoReturnable<BlockState> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            BlockState returnValue = provider.getPlacementState(new PlacementStateArgs(ctx), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"appendTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$appendTooltip(ItemStack stack, IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag context, CallbackInfo ci) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.appendTooltip(new ItemAppendTooltipEvent(stack, world, tooltip, context), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }
}

