/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.FluidState;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.recipe.RecipeManager;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.WorldAccess;

public class World
extends WorldAccess {
    private final Level world;

    protected World(Level world) {
        super((LevelAccessor)null);
        this.world = world;
    }

    public static World of(Level world) {
        return new World(world);
    }

    public Level getRaw() {
        return this.world;
    }

    public Level toMinecraft() {
        return this.getRaw();
    }

    public void addBlockEntity(BlockEntityWrapper blockEntity) {
        this.addBlockEntity(blockEntity.get());
    }

    public void addBlockEntity(BlockEntity blockEntity) {
        this.getRaw().setBlockEntity(blockEntity);
    }

    public void removeBlockEntity(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        this.getRaw().removeBlockEntity(pos.toMinecraft());
    }

    public long getTime() {
        return WorldUtil.getTime(this.getRaw());
    }

    public long getTopY() {
        return WorldUtil.getTopY(this.getRaw());
    }

    public long getBottomY() {
        return WorldUtil.getBottomY(this.getRaw());
    }

    public long getDimensionHeight() {
        return WorldUtil.getDimensionHeight(this.getRaw());
    }

    public CompatIdentifier getId() {
        return WorldUtil.getCompatWorldId(this.getRaw());
    }

    public FluidState getRawFluidState(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        return WorldUtil.getFluidState(this.getRaw(), pos.toMinecraft());
    }

    public net.pitan76.mcpitanlib.api.entity.Player getPlayerByUUID(UUID uuid) {
        return WorldUtil.getPlayer(this.getRaw(), uuid);
    }

    public List<net.pitan76.mcpitanlib.api.entity.Player> getPlayers() {
        return WorldUtil.getPlayers(this.getRaw());
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getSpawnPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(WorldUtil.getSpawnPos(this.getRaw()));
    }

    public Optional<World> getWorld(CompatIdentifier id) {
        Optional<ServerLevel> optional = WorldUtil.getWorld(this.getRaw(), id);
        return optional.map(World::of);
    }

    public Optional<ServerWorld> getServerWorld(CompatIdentifier id) {
        Optional<ServerLevel> optional = WorldUtil.getWorld(this.getRaw(), id);
        return optional.map(ServerWorld::of);
    }

    public void spawnEntity(Entity entity) {
        WorldUtil.spawnEntity(this.getRaw(), entity);
    }

    public void spawnStack(ItemStack stack, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos) {
        WorldUtil.spawnStack(this.getRaw(), pos.toMinecraft(), stack);
    }

    public RecipeManager getRecipeManager() {
        return RecipeManager.of(this.getRaw().getRecipeManager());
    }

    @Override
    @Deprecated
    public void playSound(Player playerEntity, BlockPos pos, SoundEvent sound, SoundSource category) {
        this.getRaw().playSound(playerEntity, pos, sound, category);
    }

    @Override
    @Deprecated
    public void playSound(Player playerEntity, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.getRaw().playSound(playerEntity, pos, sound, category, volume, pitch);
    }

    @Override
    public void playSound(net.pitan76.mcpitanlib.api.entity.Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(this.getRaw(), player, pos.toMinecraft(), soundEvent, category, volume, pitch);
    }

    @Override
    public void playSound(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(null, pos, soundEvent, category, 1.0f, 1.0f);
    }

    @Override
    public void playSound(net.pitan76.mcpitanlib.api.entity.Player player, net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(player, pos, soundEvent, category, 1.0f, 1.0f);
    }

    @Override
    public void playSound(net.pitan76.mcpitanlib.midohra.util.math.BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(null, pos, soundEvent, category, volume, pitch);
    }

    public Optional<ServerWorld> toServerWorld() {
        if (this.getRaw() instanceof ServerLevel) {
            return Optional.of(ServerWorld.of((ServerLevel)this.getRaw()));
        }
        return Optional.empty();
    }

    public CompatRegistryLookup getRegistryLookup() {
        return RegistryLookupUtil.getRegistryLookup(this.getRaw());
    }
}

