/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.v0.event;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LivingHurtEvent {
    public LivingEntity entity;
    public DamageSource damageSource;
    public float damageAmount;

    public LivingHurtEvent(LivingEntity entity, DamageSource damageSource, float damageAmount) {
        this.entity = entity;
        this.damageSource = damageSource;
        this.damageAmount = damageAmount;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public float getDamageAmount() {
        return this.damageAmount;
    }

    public Entity getAttacker() {
        return this.damageSource.getEntity();
    }

    public Entity getSource() {
        return this.damageSource.getDirectEntity();
    }

    public boolean isDirect() {
        return this.damageSource.isDirect();
    }

    public boolean isPlayerAttacker() {
        return this.getAttacker() instanceof Player;
    }

    public Player getPlayerEntityAttacker() {
        return (Player)this.getAttacker();
    }

    public net.pitan76.mcpitanlib.api.entity.Player getPlayerAttacker() {
        return new net.pitan76.mcpitanlib.api.entity.Player(this.getPlayerEntityAttacker());
    }

    public Level getWorld() {
        return this.entity.level();
    }

    public boolean isClient() {
        return this.getWorld().isClientSide();
    }

    public ItemStack getWeaponStack() {
        return this.getAttacker().getWeaponItem();
    }

    public Item getWeaponItem() {
        return this.getWeaponStack().getItem();
    }

    public boolean isWeaponEmpty() {
        return this.getWeaponStack().isEmpty();
    }

    public boolean isWeaponItemEqual(Item item) {
        if (this.isWeaponEmpty()) {
            return false;
        }
        return this.getWeaponItem() == item;
    }
}

