/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.tile;

import com.mojang.datafixers.types.Type;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.tile.neoforge.BlockEntityTypeBuilderImpl;

public class BlockEntityTypeBuilder<T extends BlockEntity> {
    private final Factory<? extends T> factory;
    private final List<Block> blocks;

    public BlockEntityTypeBuilder(Factory<? extends T> factory, List<Block> blocks) {
        this.factory = factory;
        this.blocks = blocks;
    }

    public static <T extends BlockEntity> BlockEntityTypeBuilder<T> create(Factory<? extends T> factory, Block ... blocks) {
        ArrayList<Block> blocksList = new ArrayList<Block>(blocks.length);
        Collections.addAll(blocksList, blocks);
        return new BlockEntityTypeBuilder<T>(factory, blocksList);
    }

    public BlockEntityTypeBuilder<T> addBlock(Block block) {
        this.blocks.add(block);
        return this;
    }

    public BlockEntityTypeBuilder<T> addBlocks(Block ... blocks) {
        Collections.addAll(this.blocks, blocks);
        return this;
    }

    public BlockEntityType<T> build() {
        return this.build(null);
    }

    public BlockEntityType<T> build(Type<?> type) {
        return BlockEntityTypeBuilder.build(type, this.factory, this.blocks.toArray(new Block[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockEntity> BlockEntityType<T> build(Type<?> type, Factory<? extends T> factory, Block ... blocks) {
        void var2_2;
        void var1_1;
        return BlockEntityTypeBuilderImpl.build(type, var1_1, (Block[])var2_2);
    }

    @FunctionalInterface
    public static interface Factory<T extends BlockEntity> {
        public T create(TileCreateEvent var1);

        @Deprecated
        default public T create(BlockPos pos, BlockState state) {
            return this.create(new TileCreateEvent(pos, state));
        }
    }
}

