/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.BlockEntityDataUtil;
import net.pitan76.mcpitanlib.api.util.BlockEntityTypeUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class BlockEntityUtil {
    public static BlockEntity getBlockEntity(Level world, BlockPos pos) {
        return WorldUtil.getBlockEntity(world, pos);
    }

    public static CompoundTag getBlockEntityNbt(@Nullable Level world, BlockEntity blockEntity) {
        if (world == null) {
            world = BlockEntityUtil.getWorld(blockEntity);
        }
        if (world == null) {
            return NbtUtil.create();
        }
        return blockEntity.saveWithoutMetadata((HolderLookup.Provider)world.registryAccess());
    }

    public static CompoundTag getBlockEntityNbt(BlockEntity blockEntity) {
        return BlockEntityUtil.getBlockEntityNbt(null, blockEntity);
    }

    public static Level getWorld(BlockEntity blockEntity) {
        return blockEntity.getLevel();
    }

    public static boolean hasWorld(BlockEntity blockEntity) {
        return blockEntity.hasLevel();
    }

    public static BlockPos getPos(BlockEntity blockEntity) {
        return blockEntity.getBlockPos();
    }

    public static BlockState getCachedState(BlockEntity blockEntity) {
        return blockEntity.getBlockState();
    }

    public static BlockState getBlockState(BlockEntity blockEntity) {
        return BlockEntityUtil.getWorld(blockEntity).getBlockState(BlockEntityUtil.getPos(blockEntity));
    }

    public static Block getBlock(BlockEntity blockEntity) {
        return BlockEntityUtil.getBlockState(blockEntity).getBlock();
    }

    public static void markRemoved(BlockEntity blockEntity) {
        blockEntity.setRemoved();
    }

    public static void markDirty(BlockEntity blockEntity) {
        blockEntity.setChanged();
    }

    public static BlockEntityType<?> getType(BlockEntity blockEntity) {
        return blockEntity.getType();
    }

    public static void readNbt(BlockEntity blockEntity, CompoundTag nbt, CompatRegistryLookup registryLookup) {
        blockEntity.loadAdditional(nbt, registryLookup.getRegistryLookup());
    }

    public static void writeNbt(BlockEntity blockEntity, CompoundTag nbt, CompatRegistryLookup registryLookup) {
        blockEntity.saveAdditional(nbt, registryLookup.getRegistryLookup());
    }

    public static void read(BlockEntity blockEntity, CompoundTag nbt, CompatRegistryLookup registryLookup) {
        blockEntity.loadWithComponents(nbt, registryLookup.getRegistryLookup());
    }

    public static CompoundTag createNbt(BlockEntity blockEntity, CompatRegistryLookup registryLookup) {
        return blockEntity.saveWithoutMetadata(registryLookup.getRegistryLookup());
    }

    public static void setStackNbt(BlockEntity blockEntity, ItemStack stack, CompatRegistryLookup registryLookup) {
        blockEntity.applyComponentsFromItemStack(stack);
    }

    public static ServerLevel getServerWorld(BlockEntity blockEntity) {
        return (ServerLevel)BlockEntityUtil.getWorld(blockEntity);
    }

    public static void writeToStack(ItemStack stack, BlockEntity blockEntity, CompatRegistryLookup registryLookup) {
        CompoundTag nbt = blockEntity.saveCustomOnly(registryLookup.getRegistryLookup());
        if (!NbtUtil.has(nbt, "id")) {
            NbtUtil.putString(nbt, "id", BlockEntityTypeUtil.toID(BlockEntityUtil.getType(blockEntity)).toString());
        }
        BlockEntityDataUtil.setBlockEntityNbt(stack, nbt);
        stack.applyComponents(blockEntity.collectComponents());
    }
}

